/* Interface for ActionCell class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * ActionCell.h,v 1.19 1994/07/16 17:04:22 pfkeb Exp
 */

 
#ifndef _ActionCell_h_
#define _ActionCell_h_

#include "Cell.h"

@class Control;
@interface ActionCell:Cell
{
    int             tag;	
    id              target;	
    SEL             action;	
    Control	    *controlView;	// not in NeXTSTEP
}
- controlView;

// - setFont:fontObj;
// - setAlignment:(int)mode;
// - setBordered:(BOOL)flag;
// - setBezeled:(BOOL)flag;
// - setEnabled:(BOOL)flag;
// - setFloatingPointFormat:(BOOL)autoRange 
//                     left:(unsigned int)leftDigits 
//                    right:(unsigned int)rightDigits;
// - setIcon:(const char *)iconName;

- target;
- setTarget:anObject;
- (SEL)action;
- setAction:(SEL)aSelector;
- (int)tag;
- setTag:(int)anInt;

// - (const char *)stringValue;
// - (int)intValue;
// - (float)floatValue;
// - (double)doubleValue;
// - setStringValue:(const char *)aString;
// - setStringValueNoCopy:(char *)aString shouldFree:(BOOL)flag;
// - drawSelf:(const NXRect *)cellFrame inView:controlView;
// - write:(NXTypedStream *)stream;

- read:(TypedStream *)stream;


- copy;
- sendAction;
- _sendActionFrom:anObject;	// an undocumented method in Cell of NS
- _setControlView:aView;
- _setFrame:(const NXRect *)frame inView:aView;
@end

#endif
