/* Interface for Box class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Box.h,v 1.19 1994/07/10 21:43:24 pfkeb Exp
 */

 
#ifndef _Box_h_
#define _Box_h_

#include "View.h"

// Box types
#define NX_NOBORDER	0
#define NX_LINE		1
#define NX_BEZEL	2
#define NX_GROOVE	3
#define NX_RIDGE	4

// Title positions:
#define NX_NOTITLE	0
#define NX_ABOVETOP	1
#define NX_ATTOP	2
#define NX_BELOWTOP	3
#define NX_ABOVEBOTTOM	4
#define NX_ATBOTTOM	5
#define NX_BELOWBOTTOM	6

#define DEF_OFFSET	5

#define BEZEL_THICKNESS 2

/* STRUCTURE OF A BOX CLASS:

       _widgetid
           |
        ---+---------
       |             |
    _boxwid      title cell object (contains a _widgetid of its own) 

   Hope this helps clarify what's going on in this class... slf
*/

@interface Box : View
{
  id       cell;	// the title cell
  View     *contentView;
  NXSize   offsets;
  NXRect   borderRect;	// should hold rect for the border... 
  NXRect   titleRect;	// bounding box of the title cell...
  char     *title;
  int      border;
  int      titlePosition;
  int	   thickness;

  // There is no corresponding member for this in NeXTSTEP:
  View     *borderView;  // holds the bordering code...
}
- initFrame:(const NXRect *)frameRect;
- awake;

// - free;

- (int)borderType;
- (int)titlePosition;
- setBorderType:(int)aType;
- setTitlePosition:(int)aPosition;
- (const char *)title;
- setTitle:(const char *)aString;
- cell;
- font;
- setFont:fontObj;
- getOffsets:(NXSize *)aSize;
- setOffsets:(NXCoord)width :(NXCoord)height;
- sizeTo:(NXCoord)width :(NXCoord)height;
- sizeToFit;
- setFrameFromContentFrame:(const NXRect *)contentFrame;
- contentView;
- setContentView:aView;
- addSubview:aView;
- replaceSubview:oldView with:newView;
- drawSelf:(const NXRect *)rects :(int)rectCount;

// - write:(NXTypedStream *)stream;

- read:(TypedStream *)stream;

// obsolete methods
// + newFrame:(const NXRect *)frameRect;

/* Methods not in NeXTSTEP */

- (void *)_widget;
- _setBorder:(NXRect *)aBorder;
- (int)heightAdjust;

@end

#endif  /* _Box_h_ */
