/* Implementation of Cell class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz,
 *          Imran Qureshi, and Libing Wang (SLAC)
 *	    Fred Harris (U Hawaii)
 *	    Make Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window syste
 *
 * Cell.m,v 1.70 1994/07/18 19:16:09 kamerer Exp
 */

#include "Cell.h"

#include <stdlib.h>
#include "Application.h"
#include <stdio.h>

extern char *CellInstanceName(void);

@implementation Cell:Object

- init
{
    [super init];
    instancename = CellInstanceName();
    return self;
}

- initTextCell:(const char *)aString
{
    [self init];
    [self setStringValue:aString];
    return self;
}

- initIconCell:(const char *)iconName
{
    [self init];
    [self setIcon:iconName];
    return self;
}

// - copyFromZone:(NXZone *)zone;

- free
{
    if ( contents ) {
	free(contents);
    }
    if ( arglist ) {
	free(arglist);
    }
    return [super free];
}

- controlView
{
    return nil;		/* as in NeXTSTEP */
}

- (int) type
{ 
    return entryType;
}

- setType:(int)aType
{
    entryType = aType;
    return self;
}

- (int)state
{
    return state;
}

- setState:(int)value
{
    state = value ? 1 : 0;
    return self;
}

// - incrementState;

- target
{
    return nil;		/* as in NeXTSTEP */
}

- setTarget:anObject
{
    return self;	/* as in NeXTSTEP */
}

/* Archiving methods */

- read:(TypedStream*)typedStream
{
	int a;

    [super read:typedStream];
    objc_read_string(typedStream, &contents);
	objc_read_type(typedStream, "i", &a);
	[self setEnabled:a];
#ifdef DEBUG
    fprintf(stderr, "reading Cell=%s\n", contents);
#endif
    return self;
}

- awake
{
    [super awake];
    instancename = CellInstanceName();

    return self;
}

- setFloatingPointFormat:(BOOL)autoRange
     left:(unsigned)leftDigits right:(unsigned)rightDigits
{
  /* Not terribly import to implement but maybe X has a way already */
    return self;
}

-(const char *)stringValue
{
    return contents;
}

- setStringValue:(const char *)aString
{
    if (aString == contents)  return self;
    
    if (contents) {
		free(contents);
    }
    if (aString) {
	contents = NXCopyStringBuffer(aString);
    } else {
	contents = NXCopyStringBuffer("Cell");
    }
    return self;
}

- (const char *)icon
{
    if (!contents) 
	return (const char *)nil;
    return contents;
}

- setIcon:(const char *)iconName
{
    if (contents)
		free(contents);
    contents = NXCopyStringBuffer(iconName);
    return self;
}

- setIntValue:(int)anInt
{
    char temp[100];
    sprintf(temp, "%d", anInt);
    [self setStringValue:temp];
    return self;
}

- (int)intValue
{
    const char 	*temp;
    
    temp = [self stringValue];
    return ( atoi(temp) );
}

- setFloatValue:(float)aFloat
{
    char temp[100];
    sprintf(temp, "%g", aFloat);
    [self setStringValue:temp];
    return self;
}

- (float)floatValue
{
    const char 	*temp;
    float 	f;
    
    temp = [self stringValue];
    f = (float)atof(temp);
    return f;
}

- setDoubleValue:(double)aDouble
{
    char temp[100];
    sprintf(temp, "%g", aDouble);
    [self setStringValue:temp];
    return self;
}

- (double)doubleValue
{
    const char 	*temp;
    
    temp = [self stringValue];
    return ( atof(temp) );
}

- takeIntValueFrom:sender
{
    [self setIntValue:[sender intValue]];
    return self;
}

- takeStringValueFrom:sender
{
   [self setStringValue:[sender stringValue]];
   return self;
}

- (BOOL)isEnabled
{
    return (!disabled);
}

- setEnabled:(BOOL)flag
{
    disabled = !flag;
    [self _setEnabled:flag];
    return self;
}

- (int)alignment
{
    return alignment;
}

- setAlignment:(int)mode
{
    alignment = mode;
    return self;
}

/* As with NeXTSTEP, these methods don't really do anything except 
 * keeping compiler warning messages away 
 */
- sendAction
{
    return nil;
}
- setAction:(SEL)anAction
{
    return self;
}
- (SEL) action
{
    return (SEL)0;
}
- (int) tag
{
    return (-1);
}
- setTag:(int)anInt
{
    return self; 
}


- copy
{
    Cell	*newCell;
    
    newCell = [[[self class] alloc] init];
    [newCell setStringValue:contents];
    [newCell setState:state];
    [newCell setAlignment:alignment];
    [newCell setEnabled:!disabled];
    [newCell _setFrame:&_frame];
    if ( parentid ) {
        [newCell _managedBy:parentid];
    }
    return newCell;
}

@end
