/* Interface for ClipView class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Paul Kunz
 *
 * This file is part of an Objective-C class library for a window system.
 *
 * ClipView.h,v 1.7 1994/06/12 00:51:58 pfkeb Exp
 */

#ifndef _CLIP_VIEW_
#define _CLIP_VIEW_
#include "View.h"

@class NXCursor;

@interface ClipView : View
{
    View	*docView;
    NXRect	_docRect;
    NXCursor	*cursor;
    int		_borderType;
}
- initFrame:(const NXRect *)frameRect;
- setDocView:aView;
- docView;
- getDocRect:(NXRect *)aRect;
- setDocCursor:anObj;
// - resetCursorRects;
- getDocVisibleRect:(NXRect *)aRect;
- descendantFrameChanged:sender;
// - descendantFlipped:sender;
// - setCopyOnScroll:(BOOL)flag;
// - setDisplayOnScroll:(BOOL)flag;
// - autoscroll:(NXEvent *)theEvent;
- constrainScroll:(NXPoint *)newOrigin;
- rawScroll:(const NXPoint *)newOrigin;
// - write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;
// - free;

- rotate:(NXCoord)angle;
- rotateTo:(NXCoord)angle;
- setDrawRotation:(NXCoord)angle;

// - awake;
// - moveTo:(NXCoord)x :(NXCoord)y;
// - sizeTo:(NXCoord)width :(NXCoord)height;
// - setDrawOrigin:(NXCoord)x :(NXCoord)y;
// - setDrawSize:(NXCoord)width :(NXCoord)height;
// - translate:(NXCoord)x :(NXCoord)y;
// - scale:(NXCoord)x :(NXCoord)y;

- _setScrollFloatValue:(float) xPercent :(float) yPercent;
- _scrollLine:(int)amount vertical:(BOOL)aFlag;
- _scrollPage:(int)context vertical:(BOOL)vFlag up:(BOOL)uFlag;
// - _setBorderType:(int)aType;

@end

@interface View(ClipViewSuperview)
- reflectScroll:aClipView;
- scrollClip:aClipView to:(const NXPoint *)aPoint;
@end

#endif	/* _CLIP_VIEW_ */