/* Implementation of CustomView class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Paul Kunz and Imran Qureshi
 *
 * This file is part of an Objective-C class library for a window system
 *
 * CustomView.m,v 1.11 1994/06/11 03:55:41 pfkeb Exp
 */


#include "CustomView.h"
#include <stdio.h>
#include <stdlib.h>

/* From Application.m */
extern id  nibOwner;


  
@implementation CustomView
- initFrame:(const NXRect *)frameRect
{	
	Class	*theClass;

	if (realObject) {
		fprintf(stderr, "CustomView: object already exists\n");
		return self;
	}
	if (strcmp(realClassName,"FileOwner")==0) {
		realObject = nibOwner;
		return self;
	}
		
	theClass = objc_get_class(realClassName);
	realObject = [[theClass alloc] initFrame:frameRect];
	instancename = "CustomView";
	return self;
} 

- write:(TypedStream *)stream
{
	[super write:stream];
	objc_write_type(stream,"*", realClassName);
	return self;
}
- read:(TypedStream *)stream
{
	[super read:stream];
	objc_read_type(stream,"*",&realClassName);
	return self;

}
- awake
{
	if (amAwake) {
		return self;
	}
	amAwake = YES;
        [self initFrame:&frame];
	return self;
}

-nibInstantiate
{
	 return realObject;
}

@end
