/* Interface for FormCell class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * FormCell.h,v 1.21 1994/06/15 18:57:42 pfkeb Exp
 */
 
#ifndef _FormCell_h_
#define _FormCell_h_

#include "ActionCell.h"

@class TextFieldCell;

@interface FormCell:ActionCell
{
    TextFieldCell *titleCell; /* The cell containing the label of this cell */
    TextFieldCell *textCell;
    NXCoord  titleWidth;
    NXCoord  titleEndPoint;
}
- init;
- initTextCell:(const char *)aString;
- free;

// - copyFromZone:(NXZone *)zone;
// - (NXCoord)titleWidth:(const NXSize *)aSize;

- (NXCoord)titleWidth;
- setTitleWidth:(NXCoord)width;
- (const char *)title;
- setTitle:(const char *)aString;

// - titleFont;
// - setTitleFont:fontObj;

- (int)titleAlignment;
- setTitleAlignment:(int)mode;
- setEnabled:(BOOL)flag;
- (BOOL)isOpaque;

// - calcCellSize:(NXSize *)theSize inRect:(const NXRect *)aRect;
// - drawInside:(const NXRect *)cellFrame inView:controlView;
// - drawSelf:(const NXRect *)cellFrame inView:controlView;
// - (BOOL)trackMouse:(NXEvent*)event inRect:(const NXRect*)aRect 
//             ofView:controlView;
// - resetCursorRect:(const NXRect *)visibleCellFrame inView:controlView;
// - write:(NXTypedStream *)stream;

- read:(NXTypedStream *)stream;

// + new;
// + newTextCell;
// + newTextCell:(const char *)aString;

- copy;
- setIntValue:(int) anInt;
- (int) intValue;
- (float) floatValue;
- setFloatValue:(float)aFloat;
- (double) doubleValue;
- setDoubleValue:(double)aDouble;
- setStringValue:(const char *)aString;
- (const char *)stringValue;
- titleCell;
- textCell;
- _managedBy:parent;
- _destroy;

@end

#endif
