/* Implementation of IBConnnector classes
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * IBConnectors.m,v 1.12 1994/06/11 03:55:56 pfkeb Exp
 */

 

/*  Archiving Category for Object */

#include "IBConnectors.h"
#include <stdio.h>
#include <stdlib.h>

/*  This is so setTarget: and setAction: are declared */
#include "Control.h"

/* This is for sel_get_uid */
#include <objc/objc-api.h>


/* This is for nibInstantiate */
#include "CustomObject.h"

#include "object-ivars.h"

@implementation IBConnector
- read:(TypedStream *) stream
{
	[super read:stream];
	objc_read_object(stream, &source);
	objc_read_object(stream, &destination);
	objc_read_type(stream, "*", &label);
	return self;
}
- write:(TypedStream *)stream
{
	[super write:stream];
	objc_write_object(stream,source);
	objc_write_object(stream,destination);
	objc_write_type(stream,"*",(char *)label);
	return self;
}
- free
{
	return [super free];
}

- source
{
	return source;
}

-destination
{
	return destination;
}

@end

@implementation IBControlConnector
- write:(TypedStream *)stream
{
	[super write:stream];
	return self;
}

- read:(TypedStream *)stream
{
	[super read:stream];
	return self;
}

- establishConnection
{
    if ( (!source) || (!destination) ) 
	return self;

  /* Give source & destination a chance to replace themselves 
   * Useful for CustomObject and CustomView 
   */
    if ( [source respondsTo:@selector(nibInstantiate)])
	source = [source nibInstantiate];
	if ( [destination respondsTo:@selector(nibInstantiate)])
	    destination = [destination nibInstantiate];
	
 /* if the objects have a setTarget: method then call that */
    if ( [source respondsTo:@selector(setTarget:)])
	[source setTarget:destination];
    else
  	object_set_instance_variable(source, "target", (void*)destination);

    if ( [source respondsTo:@selector(setAction:)])
	[source setAction:sel_get_uid(label)];
    else
  	object_set_instance_variable(source, "action", 
                                     (void*)sel_get_uid(label));
    return self;
}
@end

@implementation IBOutletConnector
- write:(TypedStream *)stream
{
	[super write:stream];
	return self;

}

- read:(TypedStream *)stream
{
	[super read:stream];
	return self;
}

- establishConnection
{
    id	outlet;
	
    if ( (!source) || (!destination)) 
	return self;

  /* Give source & destination a chance to replace themselves 
   * Useful for CustomObject and CustomView 
   */
    if ([source respondsTo:@selector(nibInstantiate)])
	source = [source nibInstantiate];
	if ([destination respondsTo:@selector(nibInstantiate)])
	    destination = [destination nibInstantiate];
	
  object_get_instance_variable(source, label, (void **)&outlet);
  object_set_instance_variable(source, label, (void*)destination);
  object_get_instance_variable(source, label, (void **)&outlet);
  
  return self;
}

@end
