/* Interface for NXBrowser class
 *
 * Copyright (C)  1993, 1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Mike Gravina, Fred Harris, Paul Kunz, 
 *          Imran Qureshi, and Libing Wang
 *	    Mike L. Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * NXBrowser.h,v 1.37 1994/08/17 05:11:09 fxmlk Exp
 */

#ifndef _NXBrowser_h_
#define _NXBrowser_h_

#include "Control.h"

@class List, Matrix, MList, Scroller, ScrollView;
@interface NXBrowser:Control
{
    id                  target;
    id                  delegate;
    List		*titleList;	/* _reserved1[0] in NeXTSTEP */
    id                  _reserved1[2];	/* ??? in NeXTSTEP */
    SEL                 action;
    SEL                 doubleAction;
    id                  matrixClass;
    id                  cellPrototype;
    int                 numVisibleCols;	/* _reserved4[2] in NeXTSTEP */
    unsigned short      pathSeparator;

 /*
  * Instance variables that are not standard in NExT-STEP implementation but
  * are necessary to make implemetation straightforward here 
  */
    int                 selectedColumn;
    Matrix		*titleMatrix; /* Matrix for Titles */
    NXRect		titleFrame;
    List		*columnList;	 /* List of ScrollViews for columns */
    List                *shadowList;	 /* List of Matrix for API */
    Scroller		*horizScroller; 
    char		*colOneTitle;
    int			titleHeight;
    int			maxVisibleCols;
    int                 minColWidth;
    int			colWidth;
    int			columnOfViewZero;  /* column index of first View */
    BOOL		hasHorizontalScroller;
    BOOL		isTitled;
    BOOL		titleFromPrev;
}
- initFrame:(const NXRect *)frameRect;
- setFrame:(const NXRect *)frameRect;

- free;
- (SEL)action;
- setAction:(SEL)aSelector;
- target;
- setTarget:anObject;
- (SEL)doubleAction;
- setDoubleAction:(SEL)aSelector;
- setMatrixClass:factoryId;
- setCellClass:factoryId;
- cellPrototype;
- setCellPrototype:aCell;
- delegate;
- setDelegate:anObject;

// - setEnabled:(BOOL)flag;
// - setMultipleSelectionEnabled:(BOOL)flag;
// - (BOOL)isMultipleSelectionEnabled;
// - setBranchSelectionEnabled:(BOOL)flag;
// - (BOOL)isBranchSelectionEnabled;
// - setEmptySelectionEnabled:(BOOL)flag;
// - (BOOL)isEmptySelectionEnabled;

- setHorizontalScrollerEnabled:(BOOL)flag;
- (BOOL)isHorizontalScrollerEnabled;

// - setHorizontalScrollButtonsEnabled:(BOOL)flag;
// - (BOOL)areHorizontalScrollButtonsEnabled;
// - reuseColumns:(BOOL)flag;
// - separateColumns:(BOOL)flag;
// - (BOOL)columnsAreSeparated;
// - useScrollButtons:(BOOL)flag;
// - useScrollBars:(BOOL)flag;

- getTitleFromPreviousColumn:(BOOL)flag;
- (BOOL)isTitled;
- setTitled:(BOOL)flag;

// - (NXRect *)getTitleFrame:(NXRect *)theRect ofColumn:(int)column;

- setTitle:(const char *)aString ofColumn:(int)column;
- (const char *)titleOfColumn:(int)column;
- drawTitle:(const char *)title inRect:(const NXRect *)aRect 
   ofColumn:(int)column;
- clearTitleInRect:(const NXRect *)aRect ofColumn:(int)column;
- (NXCoord)titleHeight;

- loadColumnZero;

// - (BOOL)isLoaded;

- setPathSeparator:(unsigned short)charCode;

- setPath:(const char *)path;

- (char *)getPath:(char *)thePath toColumn:(int)column;

// - displayColumn:(int)column;

- reloadColumn:(int)column;

// - validateVisibleColumns;

- displayAllColumns;
- scrollColumnsRightBy:(int)shiftAmount;
- scrollColumnsLeftBy:(int)shiftAmount;

// - scrollColumnToVisible:(int)column;
// - scrollUpOrDown:sender;

- reflectScroll:clipView;
- scrollViaScroller:sender;

// - updateScroller;

- setLastColumn:(int)column;
- addColumn;
- setMinColumnWidth:(int)columnWidth;

// - (int)minColumnWidth;

- setMaxVisibleColumns:(int)columnCount;

// - (int)maxVisibleColumns;
// - (int)numVisibleColumns;
// - (int)firstVisibleColumn;
// - (int)lastVisibleColumn;
// - (int)lastColumn;

- (int)selectedColumn;

- selectedCell;
- getSelectedCells:(List *)aList;

- (int)columnOf:matrix;
- matrixInColumn:(int)column;

// - getLoadedCellAtRow:(int)row inColumn:(int)col;
// - selectAll:sender;
// - (NXRect *)getFrame:(NXRect *)theRect ofColumn:(int)column;
// - (NXRect *)getFrame:(NXRect *)theRect ofInsideOfColumn:(int)column;

- tile;

// - drawSelf:(const NXRect *)rects :(int)rectCount;
// - mouseDown:(NXEvent *)theEvent;
// - sizeTo:(NXCoord)width :(NXCoord)height;
// - sizeToFit;
// - acceptArrowKeys:(BOOL)acceptFlag andSendActionMessages:(BOOL)sendFlag;
// - keyDown:(NXEvent *)theEvent;
// - (BOOL)acceptsFirstResponder;

- doClick:sender;
- doDoubleClick:sender;
- sendAction;

// + newFrame:(const NXRect *)frameRect;

- read:(TypedStream *)stream;
- awake;

@end

/* 
 * Methods implemented by an NXBrowser delegate.  Those commented out
 * are not used yet by this implementation
 */

@interface Object(BrowserDelegate)
// - (int)browser:sender getNumRowsInColumn:(int)column;
- (int)browser:sender fillMatrix:matrix inColumn:(int)column;
// - browser:sender loadCell:cell atRow:(int)row inColumn:(int)column;
// - (const char *)browser:sender titleOfColumn:(int)column;
// - (BOOL)browser:sender selectCell:(const char *)title inColumn:(int)column;
// - (BOOL)browser:sender columnIsValid:(int)column;
// - browserWillScroll:sender;
// - browserDidScroll:sender;
@end

#endif
