/* Implementation of PopUpList class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang (SLAC)
 *          Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * PopUpList.m,v 1.38 1994/07/14 20:51:01 pfkeb Exp
 */
 
#include "PopUpList.h"

#include "Menu.h"
#include <coll/List.h>
#include "MenuCell.h"
#include "Matrix.h"
#include <string.h>
#include <stdlib.h>

extern char *PopUpListInstanceName(void);

@interface PopUpList(WidgetSet)
- _initFrame;
- _realizeNewItem;
- _managedBy:parent wid:(void*)widget;
@end

@implementation PopUpList:Menu

- init
{
    [super init];
    instancename = PopUpListInstanceName();
    _menu_type = 0;

    return self;
}

- initFrame:(const NXRect *)aFrame
{
 /*
  * This method is not in NeXTSTEP.   Since our popuplist handles a popup
  * widget, it behaves like a control. 
  */

    [super init];

    frame.origin.x    = aFrame->origin.x;
    frame.origin.y    = aFrame->origin.y;
    frame.size.width  = aFrame->size.width;
    frame.size.height = aFrame->size.height;
    [self _initFrame];
    _menu_type = 0;
    return self;
}

- setAction:(SEL)aSelector
{    
    [matrix setAction:aSelector];
    return self;
}

- (SEL)action
{
    return [matrix action];
}

- setTarget:anObject
{
    [matrix setTarget:anObject];
    return self;
}
- target
{
    return [matrix target];
}
- selectCell:aCell;
{
    [matrix selectCell:aCell];
    return self;
}
- (const char *)selectedItem
{
    MenuCell	*cell = [matrix selectedCell];
    return [cell stringValue];
}

- addItem:(const char *)aString andRealize:(BOOL)flag
{
    MenuCell	*cell;
    int		i;

    i = [self indexOfItem:aString];
    if ( i >= 0 ) {
        return [[matrix cellList] objectAt:i];
    }
    [matrix addRow];
    cell = [[matrix cellList] lastObject];
    [cell setStringValue:aString];
    [cell _setControlView:matrix];
    if (flag)
     	[self _realizeNewItem];
    return cell;
}

- addItem:(const char *)aTitle
{    
    return [self addItem:aTitle andRealize:YES];
}

- insertItem:(const char *)aString at:(unsigned int)index
{
    List	*cellList = [matrix cellList];
    MenuCell	*aCell;
    int		i;
    
    i = [self indexOfItem:aString];
    if ( i >= 0 ) {
        aCell = [cellList removeObjectAt:i];
	[cellList insertObject:aCell at:index];
    } else {
        [matrix insertRowAt:index];
	aCell = [[matrix cellList] objectAt:index];
	[aCell setStringValue:aString];
    }
    [self _realizeNewItem];
    return aCell;
}

- removeItemAt:(unsigned int)index
{
    List	*cellList = [matrix cellList];
    id item;

    item = [cellList objectAt:index];
    [matrix removeRowAt:index andFree:YES];
    if (widgetid)
     	[self _realizeNewItem];

    return item;
}

- _managedBy:parent
{
    return [self _managedBy:parent wid:[parent _widget]];
}

- (int)indexOfItem:(const char *)aString
{
    List	*cellList = [matrix cellList];
    MenuCell	*aCell;
    int		i;
    
    i = [cellList count];
    while( i-- ) {
        aCell = [cellList objectAt:i];
	if ( !strcmp([aCell title], aString) ) {
	    return i;
	}
    }
    return (-1);
}



//- setSubMenu:(int)numMenu :(char **)value
//{
//    num_menu = numMenu;
//    val_arr = value;
//    return self;
//}

- (void *)_widget
{
    return widgetid;
}

- read:(TypedStream *)ts
/*
 *	Ok, we need to read in the *names* of the items in the list
 *	under this implementation, so first we read the number of names
 * 	then we allocate the array of char pointers.
 * 	Then we loop over the number of names, store them in the array
 * 	as we read them.  The actual menu items will be created in 
 * 	the ManagedBy.. method.
 */
{
    
    [super read:ts];
#ifdef DEBUG    
    fprintf(stderr, "reading PopUpList\n");
#endif
    return self;
}

- awake
{
  /* PopUpList will be initialized by the Button control */
  
  return self;
}

- awakeFrame:(const NXRect *)aFrame
{
  /* PopUpList will be initialized by the Button control */
    int		i;

 /*
  * This method is not in NeXTSTEP.   Since our popuplist handles a popup
  * widget, it behaves like a control. 
  */

    [super awake];
    instancename = PopUpListInstanceName();

    for ( i = 0; i < [[matrix cellList] count]; i++ )
    {
	[self addItem:[[[matrix cellList] objectAt:i] title] andRealize:NO];
    }
    
    /* need to be removed at some date */
    frame.origin.x    = aFrame->origin.x;
    frame.origin.y    = aFrame->origin.y;
    frame.size.width  = aFrame->size.width;
    frame.size.height = aFrame->size.height;
    _menu_type = 0;
    
    [self _initFrame];
    
    return self;
}

- write:(TypedStream *)ts
{
    return self;
}

// - sendAction
// {
//     [matrix sendAction];
//     return self;
// }
@end
