/* Implementation of Scoller class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Scroller.m,v 1.26 1994/07/18 19:16:20 kamerer Exp
 */

#include "Scroller.h"

/* Required for implementation: */
// #include "Cell.h"
#include "stdmacros.h"

extern char *ScrollerInstanceName(void);

@interface Scroller(WidgetSet)
- _init;
- (float)_floatValue;
- _setFloatValue:(float)aFloat;
- _setFloatValue:(float)aFloat :(float)percent;
- _addCallback;
- _managedBy:parent wid:(void *)widget;
@end

@implementation Scroller

- initFrame:(const NXRect *)frameRect
{
    [super initFrame:frameRect];
    instancename = ScrollerInstanceName();
    isHoriz = (frame.size.width > frame.size.height) ? YES : NO;
    return self;
}

- setFrame:(const NXRect *)frameRect
{
	[super setFrame:frameRect];
    isHoriz = (frame.size.width > frame.size.height) ? YES : NO;
	return self;
}

- target
{
    return target;
}

- setTarget:anObject
{
    target = anObject;
    return self;
}
- (SEL)action
{
    return action;
}
- setAction:(SEL)aSelector
{
    action = aSelector;
    return self;
}

- trackKnob:(NXEvent *)theEvent
{
    [self _setHitPart:NX_KNOB];
    [target perform:action with:self];
    return self;
}

- trackScrollButtons:(NXEvent *)theEvent
{
    [target perform:action with:self];
    return self;
}

- (int) hitPart
{
    return hitPart;
}

- (float)floatValue
{
    return [self _floatValue];
}

- setFloatValue:(float)aFloat :(float)percent
{
    [self _setFloatValue:aFloat :percent];
    return self;
}

- setFloatValue:(float)aFloat
{
    [self _setFloatValue:aFloat];
    return self;
}


/* The following methods are not implemented in OpenStep */

- _setHitPart:(int) part
{
    hitPart = part;
    return self;
}

- _setVertical:(BOOL)flag
{
    isHoriz = !flag;
    return self;
}

@end
