/* Interface for Text class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz and Jeff Kamerer (SLAC)
 *	    Mike L. Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Text.h,v 1.17 1994/08/16 00:18:37 kamerer Exp
 */

 
#ifndef _Text_h_
#define _Text_h_

#include "View.h"
#include <streams/streams.h>

/* justification modes */

#define NX_LEFTALIGNED 0
#define NX_RIGHTALIGNED 1
#define NX_CENTERED 2
#define NX_JUSTIFIED 3

@interface Text:View
{
	BOOL mono;
	BOOL editable;
	BOOL selectable;
	BOOL flipped;
	
	char *_textString;
	short _numTextLines;
	BOOL _justKilledWidget;
	BOOL _waitToKillWidget;
}

- initFrame:(const NXRect *)frameRect;
- initFrame:(const NXRect *)frameRect text:(const char *)theText
				    alignment:(int)mode;

- setMonoFont:(BOOL)flag;
- setEditable:(BOOL)flag;
- setSelectable:(BOOL)flag;
- setFlipped:(BOOL)flag;

- awake;

- read:(TypedStream *)ts;

- (int)textLength;
- setSel:(int)start :(int)end;
- setText:(const char *)aString;
- (int)getSubstring:(char *)buf start:(int)startPos length:(int)numChars;
- (int)textLength;
- (int)charLength;
- replaceSel:(const char *)aString;
- readText:(NXStream *)stream;
@end

@interface Text(WidgetSet)
- _textWillChange:(XmTextVerifyCallbackStruct *)cb;
- _textDidChange;
- _addCallback;
- _init_Text;
- _setText;
- _managedBy:parent;
- _setSel:(int)start :(int)end;
- (int)_getSubstring:(char *)buf start:(int)startPos length:(int)numChars;
- (int)_textLength;
- _replaceSel:(const char *)aString;
- _preReadText;
- _postReadText;
@end

#endif /* _Text_h_ */
