/*
    NXCachedImageRep - wrapped for cashing images

    Copyright (c) 1994, Adam Fedor.

    Implementation of display specific methods for X-Windows
*/

#include "NXCachedImageRep.h"
#include "Application.h"
#include "Window.h"
#include <dpsclient/xwfriends.h>

const char *NXCachedImageRepInstanceName(void)
{
    return "NXCachedImageRep";
}

@implementation NXCachedImageRep(ToolKit)

/* Copy the contents of our window to the lock-focused window */
- (BOOL)_displayDraw
{
    XWContext context;
    Drawable	  source;

    context = (XWContext)[NXApp context];
    if (!context->gstate->widget) {
	fprintf(stderr, "CachedImageRep: Focus not locked on any view\n");
	return NO;
    }
    if (!context->gstate->xgstate) {
	fprintf(stderr, "CachedImageRep: No gstate.\n");
	return NO;
    }
    source = XtWindow((Widget)[_window perform:@selector(_shell)]);
    if (!source) {
	fprintf(stderr, "CachedImageRep: Not realized.\n");
	return NO;
    }
    XCopyArea(context->display, 
		source,
		XtWindow(context->gstate->widget),
		context->gstate->xgstate,
		NX_X(&_rect),
		NX_Y(&_rect),
		NX_WIDTH(&_rect),
		NX_HEIGHT(&_rect),
		context->gstate->origin.x,
		context->gstate->origin.y);
    return YES;
}

@end
