/*
    xttools - various routines used by the Xlib portion of the GNUStep appkit

    Copyright (C) 1994, Adam Fedor.

    xttools.c,v 1.3 1994/07/31 20:59:39 fedor Exp
*/

#include <stdio.h>
#include <appkit/stdmacros.h>
#include <appkit/xttools.h>
#include <X11/Xatom.h>

#define XW_STD_COLORMAP_STR	"XWStdColormap"
#define XW_GRAY_COLORMAP_STR	"XWGrayColormap"
#define XW_RGB_COLORMAP_STR	"XWRGBColormap"
/*
static Atom	XW_GRAY_COLORMAP = 0;
static Atom	XW_RGB_COLORMAP = 0;
*/
/* Right now we define the colormaps to be X default colormaps, since 
   maybe the window manager might actually have one of these */
static Atom	XW_GRAY_COLORMAP = XA_RGB_GRAY_MAP;
static Atom	XW_RGB_COLORMAP = XA_RGB_BEST_MAP;
static Atom	XW_STD_COLORMAP = 0;

static void 
xtInitAtoms(XWContext context)
{
    if (XW_GRAY_COLORMAP == 0) {
    	XW_GRAY_COLORMAP = XInternAtom(context->display, 
		XW_GRAY_COLORMAP_STR, 0);
    	XW_RGB_COLORMAP = XInternAtom(context->display, 
		XW_RGB_COLORMAP_STR, 0);
    }
}

/* Maintaining and using colormaps */
int
xtSetGrayColormap(XWContext context, XStandardColormap *stdmap, 
	unsigned long *cells, unsigned int colors)
{
    int i;
    XColor color;

    for (i=0; i < colors; i++) {
	/* Careful to scale color from 0 to 65536 */
	color.red = color.green = color.blue = i * 256 * (256 / colors);
	color.flags = DoRed | DoGreen | DoBlue;
	if (cells)
	    color.pixel = cells[i];
	else
	    color.pixel = i;
	XStoreColor(context->display, stdmap->colormap, &color);
    }
    stdmap->red_max = colors;
    stdmap->red_mult = 1;
    stdmap->green_max = 0;
    stdmap->green_mult = 0;
    stdmap->blue_max = 0;
    stdmap->blue_mult = 0;
    stdmap->base_pixel = 0;
    if (cells) 
	stdmap->base_pixel = cells[0];
    return 0;
}

/* Not implemented. FIXME */
int
xtSetRGBColormap(XWContext context, XStandardColormap *stdmap, 
	unsigned long *cells, unsigned int colors)
{
    return 0;
}

/* Gets and or creates a standard colormap for the visual type of the
   display. On some displays, there is no need for a color map,
   so we just store the characteristics of the display. On PseudoColor displays
   we try to allocate as many  colors as possible in a shared colormap and
   go to a private colormap as a last resort.

   On PseudoColor displays, we create a gray colormap.
   This might in the future check the defaults database or an environment
   variable to determine the if the user wants a BEST_RGB colormap. 
*/
XStandardColormap *
xtDefaultColormap(XWContext context)
{
    int i, map_count;
    unsigned int 	depth, colors;
    unsigned long 	*cells;
    XStandardColormap 	*stdmap;

    if (context->map)
	return context->map;

    /* Did  the window manager already create a colormap for us? */
    xtInitAtoms(context);
    if (XW_STD_COLORMAP == 0) {
    	if (context->vinfo.class == DirectColor 
		|| context->vinfo.class == TrueColor)
	    XW_STD_COLORMAP = XW_RGB_COLORMAP;
    	else
	    XW_STD_COLORMAP = XW_GRAY_COLORMAP;
    }
    i = XGetRGBColormaps(context->display,
		DefaultRootWindow(context->display),
		&stdmap,
		&map_count,
		XW_STD_COLORMAP);
    if (i) {
	context->map = stdmap;
	return stdmap;
    }

    /* Didn't find the standard map, create our own */
    NX_MALLOC(stdmap, XStandardColormap, 1);

    /* I'm just assuming that in Direct and TrueColor display, the pixel value
       contains red in the most significant bits, then green, then blue. One
       may be able to determine this from context->vinfo.red_mask and the like

       Note: in many cases we just set stdmap->colormap to 0, since this is
       only needed to tell the Window which colormap to install, if colormap
       == 0, then we're using the DefaultColormap, and there is no need to
       install it.
    */
    if (context->vinfo.class == DirectColor
		|| context->vinfo.class == TrueColor) {
	depth = context->vinfo.bits_per_rgb;
	stdmap->colormap = 0;
    	stdmap->red_max = context->vinfo.colormap_size;
    	stdmap->red_mult = (1 << 2*depth);
    	stdmap->green_max = context->vinfo.colormap_size;
    	stdmap->green_mult = (1 << depth);
    	stdmap->blue_max = context->vinfo.colormap_size;
    	stdmap->blue_mult = 1;
    	stdmap->base_pixel = 0;
	context->map = stdmap;
	return stdmap;
    } else if (context->vinfo.class == StaticGray) {
	stdmap->colormap = 0;
    	stdmap->red_max = context->vinfo.colormap_size;
    	stdmap->red_mult = 1;
    	stdmap->green_max = 0;
    	stdmap->green_mult = 0;
    	stdmap->blue_max = 0;
    	stdmap->blue_mult = 0;
    	stdmap->base_pixel = 0;
	context->map = stdmap;
	return stdmap;
    }

    /* How do you figure out the colormap structure for StaticColor? Punt */
    /* FIXME */
    if (context->vinfo.class == StaticColor) {
	fprintf(stderr, "Error (xttools): Can't determine colormap for StaticColor displays\n");
	return NULL;
    }

    /* Only thing left is PseudoColor and GrayScale, which can be handled the
       same */
    if (context->vinfo.class != PseudoColor 
		&& context->vinfo.class != GrayScale) {
	fprintf(stderr, "Error (xttools): Unknown visual class \n");
	return NULL;
    }

    /* Try to get as many cells as possible */
    colors = context->vinfo.colormap_size - 8;
    stdmap->colormap = DefaultColormap(context->display, 
		DefaultScreen(context->display));
    i = 0;
    while (i == 0 && colors >= 64) {
    	NX_MALLOC(cells, unsigned long, colors);
    	i = XAllocColorCells(context->display, 
		stdmap->colormap,
		TRUE,
		NULL,
		0,
		cells,
		colors);
	if (i == 0) {
	    NX_FREE(cells);
	    cells = NULL;
    	    colors = colors - 8;
	}
    }

    if (i == 0) {
    	NX_FREE(cells);
	cells = NULL;
	fprintf(stderr, "Warning (xttools): Can't get enough colors - creating private map\n");
    	stdmap->colormap = XCreateColormap(context->display, 
		DefaultRootWindow(context->display),
		context->vinfo.visual,
		AllocAll);
    }

    /* Now set up the cells */
    if (XW_STD_COLORMAP == XW_RGB_COLORMAP)
    	xtSetRGBColormap(context, stdmap, cells, colors);
    else
    	xtSetGrayColormap(context, stdmap, cells, colors);

    /* FIXME: Need to change the GC so that Background and Foreground
	pixels are properly set.
    */
    context->map = stdmap;
    return stdmap;
}

/* Internal conversion of colors to pixels values */
u_long   
xtGrayToPixel(XWContext context, float gray)
{
    XStandardColormap *map;
    u_long color;

    map = context->map;
    if (map == NULL) {
	int screen = DefaultScreen(context->display);
	return (gray < 0.5) ? BlackPixel(context->display, screen)
		: WhitePixel(context->display, screen);
    }
    color = ((u_long)(0.5 + (gray * map->red_max)) * map->red_mult)
		+ ((u_long)(0.5 + (gray * map->green_max)) * map->green_mult)
		+ ((u_long)(0.5 + (gray * map->blue_max)) * map->blue_mult)
		+ map->base_pixel;
    return color;
}

u_long   
xtRGBToPixel(XWContext context, float red, float green, float blue)
{
    XStandardColormap *map;
    u_long color;

    map = context->map;
    if (map == NULL) {
	int screen = DefaultScreen(context->display);
	return (red < 0.5) ? BlackPixel(context->display, screen)
		: WhitePixel(context->display, screen);
    }
    color = ((u_long)(0.5 + (red * map->red_max)) * map->red_mult)
		+ ((u_long)(0.5 + (green * map->green_max)) * map->green_mult)
		+ ((u_long)(0.5 + (blue * map->blue_max)) * map->blue_mult)
		+ map->base_pixel;
    return color;
}

/* Not implemented. FIXME */
u_long   
xtColorToPixel(XWContext context, NXColor color)
{
    return 0;
}

/* Internal conversion of image data to pixel values
   These routines are here for consistency, but are really only used by
   xtNXBitmapImageRep.  Look at that file for more information on how these
   routines are used.
*/
u_char   *
xtMapGrays(XWContext context, u_char **src, int colorspace, int bps, int spp, 
	int ncolors, int planar, u_char *dest)
{
    int i;
    XStandardColormap *map;
    u_int  max;
    u_long color;
    u_char *gray;

    map = context->map;
    gray = src[0];	/* Ignore alpha */
    if (map == NULL)
	return 0;
    max = (1 << bps);
    for (i=0; i < ncolors; i++) {
	/* Just skip the Alpha if there is one */
    	if (planar)
	    color = (gray[i*bps/8] << ((i * bps) % 8)) % max;
	else
	    color = (gray[i*spp*bps/8] << ((i * bps) % 8)) % max;
	color = ((color * map->red_max / max) * map->red_mult
		+ (color * map->green_max / max) * map->green_mult
		+ (color * map->blue_max / max) * map->blue_mult
		+ map->base_pixel) & 0xFFFFFFFF;
	/* FIXME: Need to pack bits for displays with depth < 8 */
	dest[i] = color;
    }

    return dest;
}

/* FIXME: Only handles RGB images (no CMYK) */
u_char   *
xtMapColors(XWContext context, u_char **src, int colorspace, int bps, int spp, 
		int ncolors, int planar, u_char *dest)

{
    int i;
    XStandardColormap *map;
    u_int  max;
    u_long color;
    u_char *red, *green, *blue;
    u_char r, g, b;

    if (spp <= 2)
	return xtMapGrays(context, src, colorspace, bps, 
		spp, ncolors, planar, dest);

    map = context->map;
    if (map == NULL)
	return 0;
    max = (1 << bps);
    red = src[0];
    if (planar) {
	green = src[1];
	blue = src[2];
    }
    for (i=0; i < ncolors; i++) {
	u_int shift;
	shift = i * bps / 8;
	if (planar) {
	    r = (red[shift]   << ((i * bps) % 8)) % max;
	    g = (green[shift] << ((i * bps) % 8)) % max;
	    b = (blue[shift]  << ((i * bps) % 8)) % max;
	    /* Translate values for gray-scale display */
	    if ( map->green_max == 0 && map->blue_max == 0)
		r = (u_long)((0.3*r) + (0.59*g) + (0.11*b));
	    color = ((r * map->red_max / max) * map->red_mult
		+ (g * map->green_max / max)*map->green_mult
		+ (b * map->blue_max / max)*map->blue_mult
		+ map->base_pixel) & 0xFFFFFFFF;
	} else {
	    r = (red[i*spp*bps/8]     << ((i * bps) % 8)) % max;
	    g = (red[(i*spp+1)*bps/8] << (((i+1) * bps) % 8)) % max;
	    b = (red[(i*spp+2)*bps/8] << (((i+2) * bps) % 8)) % max;
	    /* Translate values for gray-scale display */
	    if ( map->green_max == 0 && map->blue_max == 0)
		r = (u_long)((0.3*r) + (0.59*g) + (0.11*b));
	    color = ((r * map->red_max / max) * map->red_mult
		+ (g * map->green_max / max) * map->green_mult
		+ (b * map->blue_max / max) * map->blue_mult
		+ map->base_pixel) & 0xFFFFFFFF;
	}
	/* FIXME: Need to pack bits for displays with depth < 8 */
	dest[i] = color;
    }

    return dest;
}

