
#include <coll/coll.h>

void test(id coll)
{
  TypedStream *stream;

  [coll addElementsCount:6, ((elt)0),((elt)1),((elt)5),((elt)3),
	 ((elt)4),((elt)2)];
  printf("written ");
  [coll printForDebugger];

  stream = objc_open_typed_stream_for_file("test08.data", OBJC_WRITEONLY);
  objc_write_root_object(stream, coll);
  objc_close_typed_stream(stream);
  [coll free];

  stream = objc_open_typed_stream_for_file("test08.data", OBJC_READONLY);
  objc_read_object(stream, &coll);
  printf("read    ");
  [coll printForDebugger];
  [coll free];
}

int main()
{
  id coll;

  coll = [[Array alloc] initEncoding:@encode(int)];
  test(coll);

  coll = [[Bag alloc] initEncoding:@encode(int)];
  test(coll);

  coll = [[Set alloc] initEncoding:@encode(int)];
  test(coll);

  coll = [[GapArray alloc] initEncoding:@encode(int)];
  test(coll);

  coll = [[EltNodeCollector alloc] initEncoding:@encode(int)
	  nodeCollector:[[LinkedList alloc] init]
	  nodeClass:[LinkedListEltNode class]];
  test(coll);

  coll = [[EltNodeCollector alloc] initEncoding:@encode(int)
	  nodeCollector:[[BinaryTree alloc] init]
	  nodeClass:[BinaryTreeEltNode class]];
  test(coll);

/*
  coll = [[EltNodeCollector alloc] initEncoding:@encode(int)
	  nodeClass:[RBTreeEltNode class]];
  test(coll);
*/

  exit(0);
}


