/* Interface for Objective-C LinkedList collection object
   Copyright (C) 1993 Free Software Foundation, Inc.

   Written by:  R. Andrew McCallum <mccallum@cs.rochester.edu>
   Dept. of Computer Science, U. of Rochester, Rochester, NY  14627

   This file is part of the GNU Objective-C Collection library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 

#ifndef __LinkedList_h_INCLUDE_GNU
#define __LinkedList_h_INCLUDE_GNU

#include <coll/objc-gnu2next.h>
#include <coll/IndexedCollection.h>

/* The <LinkedListComprising> protocol defines the interface to an object
   that may be an element in a LinkedList.
*/
@protocol LinkedListComprising
- nextLink;
- prevLink;
- setNextLink: (id <LinkedListComprising>)aLink;
- setPrevLink: (id <LinkedListComprising>)aLink;
@end

@interface LinkedList : IndexedCollection
{
  id _first_link;
  unsigned int _count;
}

@end

#endif /* __LinkedList_h_INCLUDE_GNU */
