
/* Generated by Interface Builder */

#import "MyView.h"
#import <appkit/NXImage.h>
#import <appkit/OpenPanel.h>
#ifdef NeXT
#import <dpsclient/wraps.h>
#import <appkit/nextstd.h>
#else
#import <appkit/stdmacros.h>
#import <appkit/graphics.h>
#import <appkit/Motif.h>
#define NX_SOVER	0
#endif

@implementation MyView

- readFile:sender
{
    id          openPanel;
    const char *filename;
    char *	types[5] = {"tiff", "tif", "eps", NULL};

    openPanel = [OpenPanel new];
    [openPanel allowMultipleFiles:NO];
    if ([openPanel runModalForTypes:types] &&
		(filename = [openPanel filename])) {
	NX_FREE(theFile);
	theFile = NXCopyStringBuffer(filename);
    	[self display];
    }
    return self;
}

- drawSelf:(const NXRect *)rects :(int)rectCount
{
    NXSize	scaledSize;
    NXSize	imageSize;
    NXPoint	factor;
    NXImage	*image;

#ifdef NeXT
    NXSetColor(NX_COLORWHITE);
    NXRectFill(&bounds);
#else
    /* Hack until something better comes along... */
    XClearArea(XtDisplay([self _widget]),
		XtWindow([self _widget]),
		0, 0, 0, 0, 
		FALSE);
#endif
    
    if (!theFile)
        return self;

    image = [[NXImage alloc] initFromFile:theFile];
    
    if (!image) {
#ifdef NeXT
	NXRunAlertPanel("Alert", "Error: Cannot load image file.",
		"OK", NULL, NULL);
#else
	fprintf(stderr, "Error: Cannot load image file.\n");
#endif
	return nil;
    }
    [[self window] setTitleAsFilename:theFile];
    [image setScalable:YES];
    [image getSize:&imageSize];


    // Size to current view's size 
    factor.x = bounds.size.width / imageSize.width;
    factor.y = bounds.size.height / imageSize.height;
    factor.x = factor.y = (factor.x < factor.y) ? factor.x : factor.y;
    scaledSize = bounds.size;
    scaledSize.width = imageSize.width * factor.x;
    scaledSize.height = imageSize.height * factor.y;
    [image setSize:&scaledSize];
    [image composite:NX_SOVER toPoint:&bounds.origin];
    [image free];
    return self;
}

- free
{
    NX_FREE(theFile);
    return [super free];
}

@end
