/*  Archiving Category for Button
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Scott Francis, Paul Kunz, and Imran Qureshi

This file is part of the nib translator for 
an Objective-C class library for X/Motif

XmButton.m,v 1.8 1994/06/11 03:53:12 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"

#define NXTypedStream TypedStream
#include <appkit/Button.h>

@interface Button (XmArchiving)
- write:(TypedStream *)stream;
@end

#include <appkit/PopUpList.h>

@implementation Button (XmArchiving)
- write:(TypedStream *)stream
{
    int                 popup;

    [super write:stream];

    popup = ([[[self cell] target] class] == [PopUpList class]);
#ifdef DEBUG
    if ( popup ) {
    printf("\n->Button");
    } else {
    printf("->Button");
    }
#endif

    objc_write_type(stream, "i", &popup);
    return self;
}

@end
