/*  Archiving Category for Text
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Mike Kienenberger (Alaska)

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmText.m

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"

#include "XmView.h"
#include <appkit/Text.h>


@interface Text (XmArchiving)
- convertCoordToMotif:sender;
- write:(TypedStream *)stream;
@end

@implementation Text (XmArchiving)
- convertCoordToMotif:sender
{
    [super convertCoordToMotif:sender];
    
 /* adjust dimensions so that un-selected widget is same as NeXT object */
 /* [I don't know what they are yet  --Mike] */
 
    return self;
}

- write:(TypedStream *)stream
{
    BOOL a, b, c, d;
    int textLen = [self textLength];
    char *contents = (char *)malloc(textLen + 2);
    
    *contents = '\0';
    [self getSubstring:contents start:0 length:textLength+1];
    [super write:stream];

#ifdef DEBUG
    printf("\n->Text");
#endif
    a = [self isMonoFont];
    b = [self isEditable];
    c = [self isSelectable];
    d = [self isFlipped];
    objc_write_type( stream, "c", &a);
    objc_write_type( stream, "c", &b);
    objc_write_type( stream, "c", &c);
    objc_write_type( stream, "c", &d);
    objc_write_type( stream, "*", contents);

    return self;
}

@end
