/* useful macros for archiving
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis and Imran Qureshi
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * archive-def.h,v 1.7 1994/06/11 03:54:15 pfkeb Exp
 */


#ifndef _TEMP_ARCHIVE
#define _TEMP_ARCHIVE

#include <appkit/graphics.h>
#include <objc/typedstream.h>

extern int objc_write_int (struct objc_typed_stream* stream, int value);
extern int objc_write_string (struct objc_typed_stream* stream,
		   const unsigned char* string, unsigned int nbytes);

/*  Thsi should be removed when float writing works !! */
#define objc_write_float(stream,floatValue) \
 { objc_write_int(stream,(int)(floatValue));}


static inline int objc_write_rect(TypedStream *stream, NXRect *aRect)
{
 /* change to float when GNU Objective-C archiving supports it.*/
    int		array[4];
    
    array[0] = aRect->origin.x;
    array[1] = aRect->origin.y;
    array[2] = aRect->size.width;
    array[3] = aRect->size.height;
    return objc_write_array(stream, "i", 4, array);
}

#define objc_read_float(stream,floatPtr) \
 { objc_read_int(stream,((int *)(floatPtr)));}


#define objc_read_rect(stream,rectPtr) \
 { objc_read_float(stream,(&((rectPtr)->origin.x))); \
 	objc_read_float(stream,(&((rectPtr)->origin.y))); \
	objc_read_float(stream,(&((rectPtr)->size.width))); \
	objc_read_float(stream,(&((rectPtr)->size.height))); \
	}

#define objc_read_size(stream,sizePtr) \
	objc_read_float(stream,(&((sizePtr)->width))); \
	objc_read_float(stream,(&((sizePtr)->height))); \
	}

/*  This function just copies one rect into another */
#define copyRect(dest,source) \
{   (dest)->origin.x = (source)->origin.x; \
	(dest)->origin.y = (source)->origin.y; \
	(dest)->size.width = (source)->size.width; \
	(dest)->size.height = (source)->size.height; \
	}

#endif