/*  Main for nib translator
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz, Imran Qureshi

This file is part of the nib translator for 
an Objective-C class library for X/Motif

trnib_main.m,v 1.4 1994/06/11 03:54:17 pfkeb Exp

*/

#include "Translator.h"
#include <appkit/Application.h>
#include <stdio.h>
#include <string.h>
#include <sys/param.h>
int 
main( int argc, char *argv[] )
{
    Translator          *transer;
    char		buf[MAXPATHLEN+2];
    char		*p;

    [Application new];

    if ( argc < 2 ) {
	printf("Usage: trnib <input-nib> [output-file]\n" );
	exit(1);
    }
    if ( argc == 2 ) {
	strcpy( buf, argv[1] );
        p = strrchr( buf, '.' );
	if ( !p ) {
	    printf("Input must be .nib\n");
	    exit (1);
	}
	p++;
	*p = '\0';
	strcat( buf, "xmib" );
    } else {
	strcpy( buf, argv[2] );
    }

    transer = [[Translator alloc] init];
    [transer translate:argv[1] into:buf];

    exit(0);
}
