/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

#include "global.h"

/*
 * Ein Typedef fuer die Menus
 */
typedef struct {
	char		*label;
	void  (*cb)();
} Menu_Glyph, *Menu_Glyph_Ptr;


/*
 * Global variables
 */
static	void	start_empty(void);

/*
 * Hier stehen die Menus
 */

static	Menu_Glyph	main_menu[12];

static	Boolean		NO_MENU = TRUE;

static	String		menun[1];
static	Menu_Glyph_Ptr	menus[1] = {main_menu};


/*
**	Function name : makeMenu
**
**	Description : erzeugt auf einem Parent eine Form, in der
**			das Controlmenu gesetzt wird.
**	Input : Widget	parent	- Zeiger auf das Parentwidget
**	Ouput : none
*/
void makeMenu (Widget parent)
{
	Widget	form;
	Widget	last, new;
	Arg	args[10];
	int	i;

	if (NO_MENU) {
		int	a  = 0;

		NO_MENU = FALSE;
		main_menu[0].label = strings[61];
		main_menu[0].cb = start_exec;
#ifndef COHERENT
		main_menu[1].label = strings[62];
		main_menu[1].cb = start_link;
		a = 1;
#endif
		main_menu[1 + a].label = strings[63];
		main_menu[1 + a].cb = start_merger;
		if (defaults.trashcan) {
			main_menu[2 + a].label = strings[68];
			main_menu[2 + a].cb = start_empty;
			a++;
		}
		main_menu[2 + a].label = strings[64];
		main_menu[3 + a].label = strings[1];
		main_menu[3 + a].cb = start_goto;
		main_menu[4 + a].label = strings[66];
		main_menu[4 + a].cb = start_root;
		main_menu[5 + a].label = strings[64];
		main_menu[6 + a].label = strings[65];
		main_menu[6 + a].cb = start_quit;
		main_menu[7 + a].label = strings[64];
		main_menu[8 + a].label = strings[67];
		main_menu[8 + a].cb = start_about;
		main_menu[9 + a].label = NULL;
		menun[0] = strings[71];		
	}
	/*
	 * Erst die Widgetform erzeugen
	 */
	XtSetArg(args[0],XtNshowGrip, FALSE);
	form = XtCreateManagedWidget ("menu_form", formWidgetClass,
					parent, args, 1);

	last = NULL;
	for (i = 0; i < XtNumber(menun); i++) {
		char	*buf;
		char	*nbuf;
		int	j;
		Widget	menu;
		Widget	but;
		Menu_Glyph	*mm;

		/*
		 * Zunaechst einmal den Menubutton erzeugen
		 */
		if (!(buf = (char *) malloc (30)) ||
		    !(nbuf = (char *) malloc (30)))
			FATAL_ERROR ("makeMenu: Malloc failed\n");
		sprintf(buf,"%s_menu",menun[i]);
		sprintf(nbuf,"%s_button",menun[i]);

		XtSetArg(args[0],XtNfromHoriz, last);
		XtSetArg(args[1],XtNlabel, menun[i]);
		XtSetArg(args[2],XtNmenuName,buf);
		XtSetArg(args[3],XtNtop,XtChainTop);
		XtSetArg(args[4],XtNbottom,XtChainTop);
		XtSetArg(args[5],XtNright,XtChainLeft);
		XtSetArg(args[6],XtNleft,XtChainLeft);
		XtSetArg(args[7],XtNwidth,60);
		XtSetArg(args[8],XtNheight,32);
		new = XtCreateManagedWidget ("menu_but", menuButtonWidgetClass,
					     form, args, 9);

		/*
		 * Jetzt das Menu erzeugen
		 */
		menu = XtCreateManagedWidget (buf, simpleMenuWidgetClass,
						toplevel, args, 0);

		mm = (Menu_Glyph *) menus[i];

		/*
		 * Nun die Menuitems erzeugen
		 */
		for (j = 0; mm[j].label; j++) {
			if (strcmp(mm[j].label,"LINE")) {
				XtSetArg(args[0],XtNlabel,mm[j].label);
				but = XtCreateManagedWidget ("menu_item",
							    smeBSBObjectClass,
							    menu, args, 1);
				if (mm[j].cb)
					XtAddCallback (but, XtNcallback,
							(XtCallbackProc) mm[j].cb,
							NULL);
			}
			else {
				but = XtCreateManagedWidget ("menu_line",
							    smeLineObjectClass,
							    menu, args, 0);
			}
		}
		last = new;
	}
	icon_bar = form;
	icon_left = last;

}


/*********************************************************
 * name:	getString
 * description:	gibt den vollen Filenamen der selection zurueck
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
char	*getString(void)
{	char	*from = NULL;

	if (selc_g || (selc_fo && selc_f < 16000)) {
		if (selc_g)
			from = getPath(selc_g);
		else {
			char *got = getPath(selc_fo->dir);

			if (!(from = (char *) malloc (strlen(got) + 4 +
						      strlen (selc_fo->file[selc_f]->name))))
				FATAL_ERROR("start_delete: Malloc faileed\n");
			if (strcmp(got,"/"))
				sprintf(from,"%s/%s",got,selc_fo->file[selc_f]->name);
			else
				sprintf(from,"/%s",selc_fo->file[selc_f]->name);
			free(got);
		}
	}
	return(from);
}


/*********************************************************
 * name:	getMulti
 * description:	Auslesen des Mutliarrays
 * input:	none	
 * output:	char	*multi-string
 * author:	Ove Kalkan
 * date:	3.8.1993
 *********************************************************/
char	*getMulti(void)
{	char	*back = NULL;

	if (multi_fo && multi_vs < 16000 && multi_ve < multi_fo->file_count) {
		int	i;
		char	*got;

		if (!(back = (char *) malloc(2)))
			FATAL_ERROR("GetMulti: Malloc failed");
		*back = '\0';
		got = getPath(multi_fo->dir);
		for (i = multi_vs; i <= multi_ve; i++) {
			if (!(back = (char *) realloc((void *) back, strlen(back) +
				strlen(got) + strlen(multi_fo->file[i]->name) + 3)))
				FATAL_ERROR("GetMulti: realloc failed.");
			if (strcmp(got,"/"))
				sprintf(back,"%s%s/%s\n",back,got,multi_fo->file[i]->name);
			else
				sprintf(back,"%s/%s\n",back,multi_fo->file[i]->name);
		}
		free(got);
		MULTI = TRUE;
	}
	return(back);
}

/*********************************************************
 * name:	start_move
 * description:	Ruft die init_move routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_move (void)
{
	char	*from = NULL;

	if (selc_fo && selc_fo->fs_type != FS_NORMAL)
		return;
	from = getString();
	if (!from)
		from = getMulti();
	init_move(from,NULL);
	free(from);
}


/*********************************************************
 * name:	start_copy
 * description:	Ruft die init_copy routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_copy (void)
{
	char	*from = NULL;

	if (selc_fo && selc_fo->fs_type != FS_NORMAL)
		return;
	from = getString();
	if (!from)
		from = getMulti();
	init_copy(from,NULL);
	free(from);
}


/*********************************************************
 * name:	start_delete
 * description:	Ruft die init_delete routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_delete (void)
{
	char	*from = NULL;

	if (selc_fo && selc_fo->fs_type != FS_NORMAL)
		return;
	from = getString();
	if (!from)
		from = getMulti();
	init_delete(from);
	free(from);
}


/*********************************************************
 * name:	start_newdir
 * description:	Ruft die init_newdir routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_newdir (void)
{
	char	*from = NULL;

	if (selc_fo && selc_fo->fs_type != FS_NORMAL)
		return;
	from = getString();
	if (!from)
		from = getPath (&root);
	init_newdir(from);
	free(from);
}



/*********************************************************
 * name:	start_exec
 * description:	Ruft die init_exec routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 ********************************************************/
void	start_exec (void)
{
	char	*from = NULL;

	if (selc_fo && selc_fo->fs_type != FS_NORMAL)
		return;
	from = getString();
	init_exec(from,NULL);
	if (from)	free(from);
}


/*********************************************************
 * name:	start_quit
 * description:	Ruft die init_quit
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_quit (void)
{
	init_quit();
}

/*********************************************************
 * name:	start_about
 * description:	Ruft die initAbout routine
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	2.7.93
 *********************************************************/
void	start_about (void)
{
	initAbout();
}

/*********************************************************
 * name:	start_info
 * description:	ruft init_info auf
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.1993
 *********************************************************/
void	start_info(void)
{
	if (selc_g || (selc_f < 16000 && selc_fo && selc_fo->fs_type == FS_NORMAL))
		init_info();
}

/*********************************************************
 * name:	start_goto
 * description:	displays the goto-requester
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
void	start_goto(void)
{
	init_goto ();
}


/*********************************************************
 * name:	start_root
 * description:	displays the change_root-dialog
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
void	start_root(void)
{
	init_root();
}

/*********************************************************
 * name:	start_WSedit
 * description:	displays the workspace-editor-dialog
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
void	start_WSedit(void)
{
	init_editWSE();
}

/*********************************************************
 * name:	start_WSdelete
 * description:	displays the workspace-delete-question
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
void	start_WSdelete(void)
{
	if (selc_ws && selc_w < 16000)
		init_deleteWSE();
}

/*********************************************************
 * name:	start_filter
 * description:	displays the set-filter-dialog
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
void	start_filter(Widget w, XtPointer c, XtPointer s)
{
	Folder_Glyph *fo = (Folder_Glyph *) c;

	if (selc_fo && selc_fo->fs_type != FS_NORMAL)
		return;
	getFilter(fo);
}

/*********************************************************
 * name:	start_empty
 * description:	empties the trashcan
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
static void	start_empty()
{
	if (defaults.trashcan) {
		char	s[1024];

		sprintf(s,"find %s/. ! -name .. -exec rm -rf {} \\;",defaults.trashcan);
/*		sprintf(s,"%s %s/.",RM_CMD,defaults.trashcan);
*/		system(s);
		sprintf(s,"%s/.",defaults.trashcan);
		refreshFolderByPathname(s);
#ifdef	HAVE_QUOTA
		showQuota(quota_label);
#endif
	}
}

#ifndef COHERENT
/*********************************************************
 * name:	start_link
 * description:	aufrufen von init_link
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	Friday,13th.Aug.1993
 *********************************************************/
void	start_link(void)
{
	char	*file = getString();

	if (selc_fo && selc_fo->fs_type != FS_NORMAL)
		return;
	init_link(NULL,file);
}
#endif
