/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include "global.h"

/*
 * Global variables
 */

static	Widget			popup_shell = NULL;
static	Widget			custom_menu = NULL;
static	Widget			custom_button;
static	Widget			popup_pane;

static	XtTranslations		popup_trans = NULL;
static	XtTranslations		custom_trans = NULL;
static	XtTranslations		enterbut_trans = NULL;
static	XtTranslations		enterbox_trans = NULL;

static	Boolean			MENU_MARK;
static	int			shown;

typedef	struct {
	char	*label;
	char	*cmd;
	Boolean	can_selected;
} Custom_Glyph;

static	Dimension		custom_count = 0;
static	Custom_Glyph		**custom = NULL;

static	void			merge_add(void);


/*********************************************************
 * name:	startPopup
 * description:	Darstellen des Popupmenu-Fensters
 * input:	das uebliche fuer einen Event. Gebraucht
 *		wird nur der XButtonEvent-Pointer
 * output:	none
 * author:	Ove Kalkan
 * date:	17.Aug.1993
 *********************************************************/
XtActionProc	startPopup (Widget w, XButtonEvent *e, String *s, Cardinal *c)
{
	Widget	pane, box;
	Widget	button;

	MENU_MARK = FALSE;
	if (popup_shell)
		XtDestroyWidget(popup_shell);

	if (!popup_trans) {
		popup_trans = XtParseTranslationTable("<Leave>: hide-popup()");
		enterbox_trans = XtParseTranslationTable("<Enter>: hide-popup()");
		enterbut_trans = XtParseTranslationTable("<Enter>: highlight() start-custom() \n\
							 <Leave>: unhighlight() hide-popup()");
		readMenu();	/* Einmal das Custom-Menu lesen */
	}
	popup_shell = XtVaCreatePopupShell("popup_shell",overrideShellWidgetClass,
						toplevel,
						XtNx,e->x_root - 50,
						XtNy,e->y_root - 10,
						NULL);
	XtOverrideTranslations(popup_shell,popup_trans);

	/* standard-menu */
	box = XtVaCreateManagedWidget("popup_box",boxWidgetClass,
						popup_shell,
						NULL);
	pane = XtVaCreateManagedWidget("popup_pane",panedWidgetClass,
						box,
						NULL);
	popup_pane = box;
	XtOverrideTranslations(popup_pane,enterbox_trans);

	if ((selc_fo && selc_fo->fs_type != FS_NORMAL) ||
	    (multi_fo && multi_fo->fs_type != FS_NORMAL)) {
		button = XtVaCreateManagedWidget("extract_button",commandWidgetClass,
							pane,
							XtNshowGrip,FALSE,
							XtNlabel,(multi_fo ? strings[82] : strings[83]),
							NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) start_extract,NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

	}
	else {
		button = XtVaCreateManagedWidget("move_button",commandWidgetClass,
							pane,
							XtNshowGrip,FALSE,
							XtNlabel,(multi_fo ? strings[84] : strings[85]),
							NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) start_move,NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

		button = XtVaCreateManagedWidget("copy_button",commandWidgetClass,
							pane,
							XtNshowGrip,FALSE,
							XtNlabel,(multi_fo ? strings[86] : strings[87]),
							NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) start_copy,NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

		button = XtVaCreateManagedWidget("delete_button",commandWidgetClass,
							pane,
							XtNshowGrip,FALSE,
							XtNlabel,(multi_fo ? strings[88] : strings[89]),
							NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) start_delete,NULL);
		XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

		if (!multi_fo) {
			button = XtVaCreateManagedWidget("link_button",commandWidgetClass,
								pane,
								XtNshowGrip,FALSE,
								XtNlabel,strings[62],
								NULL);	
			XtAddCallback (button,XtNcallback, (XtCallbackProc) start_link,NULL);
			XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

			button = XtVaCreateManagedWidget("newdir_button",commandWidgetClass,
								pane,
								XtNshowGrip,FALSE,
								XtNlabel,strings[90],
								NULL);
			XtAddCallback (button,XtNcallback, (XtCallbackProc) start_newdir,NULL);
			XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

			if (selc_g || (selc_fo && selc_f < 16000)) {
				button = XtVaCreateManagedWidget("newdir_button",commandWidgetClass,
									pane,
									XtNshowGrip,FALSE,
									XtNlabel,strings[91],
									NULL);
				XtAddCallback (button,XtNcallback, (XtCallbackProc) start_info,NULL);
				XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

				if (merge_window != NULL) {
					button = XtVaCreateManagedWidget("newdir_button",commandWidgetClass,
										pane,
										XtNshowGrip,FALSE,
										XtNlabel,strings[92],
										NULL);
					XtAddCallback (button,XtNcallback, (XtCallbackProc) merge_add,NULL);
					XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);
				}
			}
			button = XtVaCreateManagedWidget("exec_button",commandWidgetClass,
								pane,
								XtNshowGrip,FALSE,
								XtNlabel,strings[61],
								NULL);
			XtAddCallback (button,XtNcallback, (XtCallbackProc) start_exec,NULL);
			XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);

			/* Userdefined menu */
			if (custom_count) {
				button = XtVaCreateManagedWidget("menu_button",commandWidgetClass,
								pane,
								XtNshowGrip,FALSE,
								XtNlabel,strings[93],
								NULL);
				XtOverrideTranslations(button,enterbut_trans);
				custom_button = button;
			}
		}
		else {
			if (merge_window != NULL) {
				button = XtVaCreateManagedWidget("newdir_button",commandWidgetClass,
									pane,
									XtNshowGrip,FALSE,
									XtNlabel,strings[92],
									NULL);
				XtAddCallback (button,XtNcallback, (XtCallbackProc) merge_add,NULL);
				XtAddCallback (button,XtNcallback, (XtCallbackProc) hidePopup,NULL);
			}
		}
	}

	XtManageChild(popup_shell);
}


/*********************************************************
 * name:	hidePopup
 * description:	Verstecken des popup-menus
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	17.Aug.1993
 *********************************************************/
XtActionProc	hidePopup (Widget w, XEvent *e, String *s, Cardinal *c)
{
	if (w == popup_pane) {
		MENU_MARK = FALSE;
		if (custom_menu)
			XtUnmanageChild(custom_menu);
	}
	else if (!MENU_MARK) {
		if (popup_shell)
			XtDestroyWidget(popup_shell);
		popup_shell = NULL;
		if (custom_menu)
			XtDestroyWidget(custom_menu);
		custom_menu = NULL;
	}
	else if (MENU_MARK && (w == custom_menu)) {
		XtUnmanageChild(custom_menu);
		MENU_MARK = FALSE;
	}
}


/*********************************************************
 * name:	startCustom
 * description:	displayen des Custom-Menus
 * input:	Das uebliche fuer Events
 * output:	none
 * author:	Ove Kalkan
 * date:	
 *********************************************************/
XtActionProc	startCustom (Widget w, XEnterWindowEvent *e, String *s, Cardinal *c)
{
	MENU_MARK = TRUE;
	if (!custom_menu) {
		Widget	box,button,pane;
		int	i;

		if (!custom_trans) {
			custom_trans = XtParseTranslationTable("<Leave>: hide-popup()");
		}
		custom_menu = XtVaCreatePopupShell("custom_shell",overrideShellWidgetClass,
						toplevel,
						XtNx,e->x_root - 50,
						XtNy,e->y_root - 10,
						NULL);
		XtOverrideTranslations(custom_menu,custom_trans);

		/* standard-menu */
		box = XtVaCreateManagedWidget("custom_box",boxWidgetClass,
						custom_menu,
						NULL);
		pane = XtVaCreateManagedWidget("custom_pane",panedWidgetClass,
						box,
						NULL);
		shown = 0;
		for (i = 0; i < custom_count; i++) {
			if (custom[i]->can_selected || selc_g || (selc_fo && selc_f < 16000)) {
				button = XtVaCreateManagedWidget("button",commandWidgetClass,
								pane,
								XtNshowGrip,FALSE,
								XtNlabel,custom[i]->label,
								NULL);
				XtAddCallback(button,XtNcallback,(XtCallbackProc) startExecPopup,
						(XtPointer) custom[i]->cmd);
				XtAddCallback(button,XtNcallback,(XtCallbackProc) hidePopup, NULL);
				shown++;
			}
		}
	}
	if (shown)
		XtManageChild(custom_menu);
}



/*********************************************************
 * name:	readMenu
 * description:	einlesen des custom-menus
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	17.Aug.1993
 *********************************************************/
void	readMenu (void) 
{
	FILE	*fp;
	char	s[1024];
	char	*home;

	home = getenv("HOME");
	if (strcmp(home,"/"))
		sprintf(s,"%s/.xfmmenurc",home);
	else
		sprintf(s,"/.xfmmenurc");
	if (!(fp = fopen(s,"r")) && !(fp = fopen(DEFAULT_CUSTOM,"r")))
		return;

	s[1023] = '\0';
	while (fgets(s,1023,fp)) {
		char	*ss, *sss;
		char	*label, *command;
		int	flag;
		Custom_Glyph	*g;

		if (s[0] != '#' && s[0] != '\n') {
			ss = s;
			sss = strchr(ss,':');
			*sss++ = '\0';
			if (strlen(ss)) {
				if (!(label = (char *) malloc(strlen(ss) + 1)))
					FATAL_ERROR("readMenu: Malloc failed");
				sprintf(label,"%s",ss);
				ss = sss;
				sss = strchr(ss,':');
				*sss++ = '\0';
				if (strlen(ss)) {
					if (!(command = (char *) malloc(strlen(ss) + 1)))
						FATAL_ERROR("readMenu: Malloc failed.");
					sprintf(command,"%s",ss);
					ss = sss;
					sscanf(ss,"%d",&flag);
					if (!(g = (Custom_Glyph *) malloc(sizeof(Custom_Glyph))))
						FATAL_ERROR("readMenu: malloc failed.");
					custom_count++;
					if (!custom) {
						if (!(custom = (Custom_Glyph **) malloc(sizeof(Custom_Glyph *))))
							FATAL_ERROR("readMenu: malloc failed");
					}
					else {
						if (!(custom = (Custom_Glyph **) realloc((void *) custom,
											sizeof(Custom_Glyph *) * custom_count)))
							FATAL_ERROR("readMenu: realloc failed");
					}
					custom[custom_count - 1] = g;
					g->label = label;
					g->cmd = command;
					g->can_selected = flag;
				}
				else
					free(label);
			}
		}
	}
	fclose(fp);
}


/*********************************************************
 * name:	startExecPopup
 * description:	ausfuehren eines custom-popup-entries.
 * input:	nur den command-string;
 * output:	none
 * author:	Ove Kalkan
 * date:	17.Aug.1993
 *********************************************************/
void	startExecPopup (Widget w, XtPointer client, XtPointer call)
{
	char	*cmd = (char *) client;
	char	buf[1024];

	if (strstr(cmd,"%s")) {
		char	*got = getString();
		char	*a;

		if (got)
			sprintf(buf,cmd,got);
		else
			sprintf(buf,cmd,"");
		if ((a = strstr(buf,"&"))) {
			*a = ' ';
			init_exec(buf,NULL);
		}
		else {
			system(buf);
			refreshFolderByPathname(got);
		}

		free(got);
	}
	else
		exec_exec(cmd,NULL);
	MENU_MARK = FALSE;
}


/*********************************************************
 * name:	merge_add
 * description:	anfuegen von Items in das Merge-Window
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	8.Sep.1993
 *********************************************************/
static	void	merge_add(void)
{
	char	*got;

	XtVaSetValues(merge_window,XtNeditType,XawtextAppend,NULL);
	got = getString();
	if (got) {
		XawTextPosition	pos;
		XawTextBlock	text;
		char	s[1024];

		sprintf(s,"%s\n",got);
		text.ptr = s;
		text.length = strlen(s);
		text.format = FMT8BIT;
		text.firstPos = 0;
		XawTextSetInsertionPoint(merge_window,0);
		if ((pos = XawTextSearch(merge_window,XawsdRight,&text)) == XawTextSearchError) {
			XawTextReplace(merge_window,0,0,&text);
		}
		else {
			XawTextSetSelection(merge_window,pos,pos+text.length);
			WARNING("Item is allready in this package");
		}
		free(got);
	}
	else if (multi_fo && multi_vs < 16000 && multi_ve < 16000) {
		int	i;
		char		s[1024];

		got = getPath(multi_fo->dir);
		for (i = multi_vs; i <= multi_ve; i++) {
			XawTextPosition	pos;
			XawTextBlock	text;

			if (strcmp(got,"/"))
				sprintf(s,"%s/%s\n",got,multi_fo->file[i]->name);
			else
				sprintf(s,"/%s\n",multi_fo->file[i]->name);
			text.ptr = s;
			text.length = strlen(s);
			text.format = FMT8BIT;
			text.firstPos = 0;
			XawTextSetInsertionPoint(merge_window,0);
			if ((pos = XawTextSearch(merge_window,XawsdRight,&text)) == XawTextSearchError) {
				XawTextReplace(merge_window,0,0,&text);
			}
			else {
				XawTextSetSelection(merge_window,pos,pos+text.length);
				WARNING("Item is allready in this package");
			}
		}
		free(got);
	}
	XtVaSetValues(merge_window,XtNeditType,XawtextRead,NULL);
}
