/* Controller.m
*  Purpose: How to implement a normal browser.
*
*  You may freely copy, distribute, and reuse the code in this example.
*  NeXT disclaims any warranty of any kind, expressed or  implied, as to its fitness
*  for any particular use.
*
*/


#import <appkit/Matrix.h>
#import <appkit/NXBrowser.h>
#import <appkit/NXBrowserCell.h>
#import <appkit/ScrollView.h>
#import "Controller.h"

@implementation Controller

- appDidInit:sender
{
	[myBrowser setDelegate:self];
	[myBrowser loadColumnZero];
	return self;
}

- (int)browser:sender fillMatrix:matrix inColumn:(int)column
{
	char	buf[255];
	int	row;
	id	cell;
	
	for (row = 0; row < NUMROWS; row++)
	{
		sprintf(buf,"Column %d    Row %d", column, row);
		[matrix addRow];
		cell = [matrix cellAt: row  :0];	
		/* Each column of the browser contains a separate */
		/* matrix. So for each column in the browser we want */
		/* to insert into column 0 for that matrix */  
		[cell setStringValue:buf];
		[cell setLoaded:YES];
		[cell setLeaf:column < NUMCOLUMNS-1? NO : YES];
	}
	return NUMROWS;
}

@end
