/* BigView.h
 * Purpose: Demonstrates custom pagination.
 * a BigView is a "matrix" of 3x4 rectangles, each of which is 8" x 10"
 * A bigView therefore has very logical page breaks, although the Appkit by
 * default won't break up the bigView on those boundaries.  This class demonstrates
 * how to do this.  This class also demonstrates somewhat optimized scrolling by only
 * drawing affected pages (because a page is the smallest divisible unit in this class.)
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 */

#import <appkit/View.h>

#define AUTO 0
#define AUTOWITHHELP 1
#define APPCONTROLLED 2

@interface BigView:View
{
	id pi;
	float realScale;
}

void _drawRect(float x, float y, char *str, char *num, BOOL darkFlag);

- initFrame:(const NXRect *)frameRect;
- drawSelf:(const NXRect *)rects :(int)rectCount;
- (BOOL)knowsPagesFirst:(int *)firstPageNum last:(int *)lastPageNum;
- (BOOL)getRect:(NXRect *)theRect forPage:(int)page;
- placePrintRect:(const NXRect *)aRect offset:(NXPoint *)location;
- addToPageSetup;
- adjustPageHeightNew:(float *)newBottom
	top:(float)oldTop
	bottom:(float)oldBottom
	limit:(float)bottomLimit;
- adjustPageWidthNew:(float *)newRight
	left:(float)oldLeft
	right:(float)oldRight
	limit:(float)rightLimit;
- endPrologue;
- setPrintInfo:newPi;

@end
