/* MyPageLayout.m
 * Purpose: A subclass of the PageLayout panel that displays more of the
 * information from NXApp's PrintInfo object.  If you add an accessory
 * View to the PageLayout panel, you commonly need to subclass it to
 * keep your fields in sync with the user's chosen units.
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 * Written by: Samuel Streeper
 * Created: (04/April/91)
 */

#import "MyPageLayout.h"
#import "MyPrintInfo.h"
#import "BigView.h"
#import <appkit/Application.h>
#import <appkit/Form.h>
#import <appkit/ButtonCell.h>
#import <appkit/FormCell.h>

@implementation MyPageLayout

- (int) runModal
{
	if (!p1AccessoryView)
	{
		//  Initialization probably belongs in new, but [PageLayout new]
		//	does really funky stuff that breaks this...
		//	here we load the nib file that contains our accessory view.
		//  This code only gets executed once, because the nib initializes
		//  the p1AccessoryView outlet to a meaningful value.
		
		[NXApp loadNibSection:"MyPageLayout.nib" owner:self withNames:NO];
		[self setAccessoryView:p1AccessoryView];
	}

	return [super runModal];
}

- pickedUnits:sender
/*
 * Called when the user selects different units (e.g. cm or inches).
 * Must update the margin fields.
 */
{
    float old, new;

    [self convertOldFactor:&old newFactor:&new];
    [[margins cellAt:0:0] setFloatValue:new * [[margins cellAt:0:0] floatValue] / old];
    [[margins cellAt:1:0] setFloatValue:new * [[margins cellAt:1:0] floatValue] / old];
    [[margins cellAt:2:0] setFloatValue:new * [[margins cellAt:2:0] floatValue] / old];
    [[margins cellAt:3:0] setFloatValue:new * [[margins cellAt:3:0] floatValue] / old];

    return [super pickedUnits:sender];
}

// When the panel comes up, read the global printInfo object and set the
// panels fields appropriately.
- readPrintInfo
{
    float conversion, dummy;
    NXCoord left, right, top, bottom;
	id pi;
	
    [super readPrintInfo];

	pi = [NXApp printInfo];
	[[centerButtons cellAt:0:0] setState:[pi isHorizCentered]];
	[[centerButtons cellAt:1:0] setState:[pi isVertCentered]];

	[vertButtons selectCellAt:[pi vertPagination]:0];
	[horButtons selectCellAt:[pi horizPagination]:0];

	[paginationButtons selectCellAt:([[NXApp printInfo] paginationMode]):0];
	
    [[MyPageLayout new] convertOldFactor:&conversion newFactor:&dummy];
    [pi getMarginLeft:&left right:&right top:&top bottom:&bottom];
    [[margins cellAt:0:0] setFloatValue:left * conversion];
    [[margins cellAt:1:0] setFloatValue:right * conversion];
    [[margins cellAt:2:0] setFloatValue:top * conversion];
    [[margins cellAt:3:0] setFloatValue:bottom * conversion];

	return self;
}

// If the user hits OK, this method saves the panels settings to the
// global printInfo object.
- writePrintInfo
{
    id pi;
    float conversion, dummy;

    [super writePrintInfo];
    pi = [NXApp printInfo];
    [self convertOldFactor:&conversion newFactor:&dummy];
    if (conversion) {
		[pi setMarginLeft:[[margins cellAt:0:0] floatValue] / conversion
				right:	[[margins cellAt:1:0] floatValue] / conversion
				top:	[[margins cellAt:2:0] floatValue] / conversion
				bottom:	[[margins cellAt:3:0] floatValue] / conversion];
    }
	
	[pi setHorizCentered: [[centerButtons cellAt:0:0] state]];
	[pi setVertCentered: [[centerButtons cellAt:1:0] state]];

	[pi setVertPagination: [vertButtons selectedRow]];
	[pi setHorizPagination: [horButtons selectedRow]];

	[[NXApp printInfo] setPaginationMode:([paginationButtons selectedRow])];
	return self;
}


@end

