/* BigView.m
 * Purpose: This class functions as NXApp's delegate, initializing stuff
 * before PaginationLab runs.  It also handles requests to run the
 * pageLayout panel.
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 * Written by: Samuel Streeper
 * Created: (04/April/91)
 */

#import "Worker.h"
#import "MyPageLayout.h"
#import "MyPrintInfo.h"
#import <appkit/Application.h>
#import <appkit/Form.h>
#import <appkit/ButtonCell.h>
#import <appkit/FormCell.h>
#import <appkit/ClipView.h>
#import <appkit/ScrollView.h>

@implementation Worker

- runPageLayout:sender
{
	[[MyPageLayout new] runModal];
		
    return self;
}

- appDidInit:sender
{
	NXRect bvRect, cvRect;
	NXPoint pt;
	id newPi;
	id clipView = [myBigView superview];

	[clipView allocateGState];	// otherwise halftone phase is wrong on scrolling
	
	// The following lines of code simply scroll the BigView so that
	// it's top is showing, rather than it's coordinate origin.  Yes,
	// I know this code is ugly...
	
	[myBigView getBounds:&bvRect];
	[clipView getBounds:&cvRect];
	pt = cvRect.origin;
	pt.y = bvRect.size.height - cvRect.size.height;
	[clipView rawScroll:&pt];
	[[clipView superview] reflectScroll:clipView];
	
	//set the new modified PrintInfo, free the old one
	newPi = [[MyPrintInfo alloc] init];
	[[NXApp setPrintInfo: newPi] free];
	[myBigView setPrintInfo:newPi];
	
	[[myBigView window] makeKeyAndOrderFront:self];
	return self;
}






@end
