;
;
; This program, originally available on the Motorola DSP bulletin board,
; is provided under a DISCLAIMER OF WARRANTY available from Motorola DSP
; Operation, 6501 William Cannon Drive, West, Austin, Texas  78735-8598.
;
;       LOADER FOR OPERATING SYSTEM.
;       THIS LOADER IS LOADED IN FROM THE BOOT ROM AT $C000 AND
;       LOADS THE OPERATING SYTEM FROM THE MEMORY IMMEDIATLY FOLLOWING
;       THE LOADER TO ADDRESS $E000.
;       THE LOADER OCCUPIES ADDRESSES $C000-$C05F
;
        PAGE    132,60,5,5
        OPT     NOINTR
        ORG     P:$0000
;
;       LOAD FROM LOW ORDER EPROM
;
LOADLO
        MOVE    #$C060,R0       ;START OF OP SYS IN EPROM
        MOVE    #$E000,R1       ;PLACE TO PUT OPSYS
        DO      #2698,_L1       ;2716 WORDS OF OPERATING SYSTEM
        DO      #3,_L2          ;3 BYTES/WORD
        MOVE    P:(R0)+,A2      ;GET BYTE
        REP     #8              ;SHIFT 
        ASR     A               ;TO FORM WORD
_L2
        MOVE    A1,P:(R1)+      ;SAVE IN PROG RAM
_L1
;
;       LOAD FROM MID EPROM
;
LOADMID
        MOVE    #$C000,R0       ;POINT TO START OF MID EPROM
        DO      #2730,_L1       ;NUMBER OF WORDS IN EPROM
        CLR     B               ;CLEAR WORD TO FORM
        DO      #3,_L2          ;PACK 3 BYTES TOGETHER
        MOVE    P:(R0)+,A       ;GET BYTES
        REP     #16             ;SHIFT MID BYTE TO A2
        ASL     A               ;SHIFT IT
        MOVE    A2,B2           ;PUT MID BYTE IN B2
        REP     #8              ;PACK INTO B1
        ASR     B
_L2
        MOVE    B1,P:(R1)+      ;STORE IN PROG RAM
_L1
        JMP     $E000           ;GO START MONITOR
LDREND  EQU     *               ;FIRST EMPTY LOCATION
        END
