/*
	Card.h
	Version 0.0		6/26/90		Ernest N. Prabhakar
	Version 0.1		6/29/90		Ernest N. Prabhakar
	Version 1.0		7/17/90		Ernest N. Prabhakar
	Version 1.1		8/17/90		Ernest N. Prabhakar
	
*/
#define CARD_VERSION 1
#import <objc/Storage.h>

typedef struct _CardFace {
	char *data;
	int length;
	int tag;	
	id object; } CardFace;
static const char *cardDescription = "{*ii@}";

@interface Card : Storage
 /*
  * A Card is any object to be collected in a Deck. 
  * Card is expected to receive the following messages
  *	- findSTR:aString (returns self or nil) 
  *		This is to support searching.  Can also use the compiled regex.
  *	- (int)compare:aCard (-,0,+ if self <,=,> aCard)
  *		This is to support finding.
  * This particular implementation is designed for use with
  * flashcards, index cards, or playing cards.  It implements the
  * data as strings which can be read from/to streams.
  * Data streams are usually RTF or PostScript, but it doesn't matter.
  * Tags are generic storage.  Must be set directly.
  */
 /*
  * METHOD TYPES
  * Creating
  * set parameters for Find and Sort
  * setting and retrieving values to strings or streams
  * 'findSTR:' for Card find
  * 'compare:' for Card sort
  * Action methods
  */

/* Creating and Archiving */

+ initialize;
 /*
  * TYPE: Creating; Set initial parameters
  *
  * Sets up a new Card.  Registers version.
  */

+ new;
 /*
  * TYPE: Creating; Make a new Card.
  *
  * Creates a Card with two (2) faces;
  */

+ newCount:(unsigned)numSlots;
 /*
  * TYPE: Creating; Make a new Card.
  *
  * Creates a Card with count faces;
  */

/* Set and Return Parameters */
  
+ (int) activeFace;
+ setActiveFace:(int)face;

+ (int) sortFlag;
+ setSortFlag:(int)flag;

 /*
  * TYPE: Parameters; Sets and returns values used for sort/find.
  *
  * Application-wide Card parameters.
  *
  * These are initially set to zero.
  * Set messages set those variables to the given value,
  * The others return it.
  * If 'face' is out of range, nothing is changed,
  * There are no restrictions on 'flag' value, so to change sorting 
  * all you would need is redefine the compare method.
  * Existing values use String, InvertedStrings, and the Tag to sort;
  */

/* Data input and output */
- printStream:(NXStream *)stream;
- scanStream:(NXStream *)stream;
 /*
  * TYPE: Archiving; Reads/Writes quoted, comma-separated strings.
  */


/* Set Data values */

- setFace:(int)face string:(STR)string;
- setFace:(int)face stream:(NXStream *)stream;
 /*
  * TYPE: Manipulating Faces; Sets Data
  *
  * Set the data value to a string, 
  * reading either a String or from a Stream.
  *
  */

- (STR) faceString:(int)face;
- (NXStream *)faceStream:(int)face;
 /*
  * TYPE: Manipulating Faces; Returns Data
  *
  * Either returns the value of the data string,
  * or writes it out to the returned stream.
  *
  */

- setFace:(int)face tag:(int)tag;
 /*
  * TYPE: Manipulating Faces; Sets Tag
  *
  * reading either a String or from a Stream.
  *
  */

- (int) faceTag:(int)face;
 /*
  * TYPE: Manipulating Faces; Returns Tag
  *
  * returns tag value (integer)
  *
  */
   
- setFace:(int)face object:anObject;
 /*
  * TYPE: Manipulating Faces; Sets Object
  *
  * reading an Object
  *
  */

- faceObject:(int)face;
 /*
  * TYPE: Manipulating Faces; Returns Object
  *
  * returns object
  *
  */
   
/* Find and Sort Cards */

- findSTR:(STR)aString;
 /*
  * TYPE: Finding; Tries to find String
  *
  * If aString matches faces[sortFace], return that data string.
  * Otherwise return null.  Can also use regular expersion (re_cmp).
  */

- (int)compare:aCard; //(-,0,+ if self <,=,> aCard)
 /*
  * TYPE: Sort;  Sorts according to sortFace and sortType.
  *
  * Pulls out the equivalent sortFace string and compares it.
  * If sortType is zero, it just does a lexographic compare.
  * Otherwise, it reverse strings before comparison.
  * You can overrule this for specialize Card types.
  */

/* Card Manipulation */

- flip;
 /*
  * TYPE: Manipulation; Changes order of Faces
  *
  * Makes the first element the last, and shifts the rest down.
  * i.e., for two faces simply flips the card over. 
  */

@end

#define CARDSORT_Face 0
#define CARDSORT_InvFace -1
#define CARDSORT_Tag 1
#define CARDSORT_Object 2
