#import <appkit/Responder.h>
#define Notify(title, msg) NXRunAlertPanel(title, msg, "OK", NULL, NULL)
#define	NotifyArg(title, msg, arg)\
 NXRunAlertPanel(title, msg, "OK", NULL, NULL, arg)

@interface Document : Responder
{
    id contents;		/* the document's contents */
    id window;			/* the window it is in */
    id view;			/* main or current view */
    char *name;			/* the name of the document */
    char *directory;		/* the directory it is in */
    BOOL haveSavedDocument;	/* is associated with a disk file */
}

/* Factory methods */

+ new;
+ newFromContents:content;
+ newFromFile:(const char *)file;

/* Instance methods */

- getWindowFromNib:(const char *)nibFile;
- getWindowForView:newView;
- getWindow:aWindow;
- free;

- contents;
- window;
- view;
- find:sender;

/* Action methods for Referencing Apps */

- reference:(char *)refName;
- webster:sender;
- librarian:sender;
- quotation:sender;

/* File Action Methods */

- save:sender;
- saveAs:sender;
- revertToSaved:sender;

/* Document name and file handling methods */

- (const char *)filename;
- (const char *)directory;
- (const char *)name;
- setName:(const char *)name andDirectory:(const char *)directory;
- setName:(const char *)name;
- save;

/* Window & Text delegate methods */

- windowWillClose:sender;
- windowWillResize:sender toSize:(NXSize *)size;
- windowDidResize:sender;
- resetScrollers;

@end

