/*
	Random.h
	Version 0.0		8/21/90		Ernest N. Prabhakar
	
*/

#import <objc/Object.h>

@interface Random : Object
 /* 
  * Random is an OOPS interface to the Unix psuedo-random number generator.
  * It can output flat, gaussian, or exponential statistics.
  * You can set limits for the various ranges.
  * Default type is float, though you can get flat ints.
  */
{
    float low;			/* Limits on number returned */
    float range;		/* high - low of number returned */
    int type;			/* Type of value returned  */
}
 /*
  * METHOD TYPES
  * Creating and freeing a Random object
  * Archiving
  * Giving random position in Random before marker.
  */


+ initialize;
/*
 * Seed the Random number generator
 */

+ new;
/*
 * New generator with 16 bytes of data
 */

+ newCount:(unsigned)numSlots;
/*
 * New generator with n (8 or more) bytes of data
 */

- seed;
/*
 * Random seed.  Generates a new Random sequence
 */

- seedFixed;
/*
 * Generates a fixed sequence, for testing. 
 */

- (int)integer;
/*
 * Returns an 31-bit integer less than LONG_MAX
 */

- (float) unit;
/*
 * Returns the appropriate type of random number, of unit 'size'.
 */

- (float)number;
/*
 * Returns a scaled random number of the current type
 */

- (int)whole;
/*
 * Returns a whole  number of the current type
 */

- (float)flat;
- (float)exp;
- (float)gauss;
/*
 * Sets the default type of random number
 * Returns the desired value, scaled as needed.
 */

- (float)scaleFrom:(float)nLow to:(float)nHigh;
/*
 * Set the range of values to return, especially for flat.
 */

- (float)scaleMean:(float)nMean stdDev:(float)nDev;
/*
 * Set the range of values to return, especially for gaussian.
 */

- (int)partition:(int)numTotal part:(int)num of:(int)denom;
/*
 * Return a random number in a given interval, as in
 * parition:12 part:2 of:3 giving 4,5,6, or 7.
 */

@end

