/*************************************************************************
*		Copyright (c) 1989,1990 Stone Design Corp.  All rights reserved. 
*		"Do what you will, you will anyway...."-- andrew stone 4-29-90
***************************************************************************/

#import <appkit/Slider.h>

@interface SliderDualActing:Slider
{
    id  textPal;		// Our drone, but sometimes active textField
    id	upTarget;		// Who we send the text field and mouseup message to
    SEL	upAction;		// the call needed
    
	id  undoTarget;		// who manages our undo, we do by default
	int undoPosition;   // position of undo #define
    double lastValue;	// we stash the last value here for undo
}

 // Initialization:
+ newFrame:(const NXRect *)frameRect;

 // IB sender methods:
- sendTextAction:sender;      	// method for textField to call
- incrementDecrement:sender;  	// method for inc./dec. buttons matrix

 // overridden superclass methods:
- mouseDown:(NXEvent *)e;
- setFloatValue:(float)aFloat;
- setIntValue:(int)anInt;

 // initialization routines called by clients:
- setUpTarget:anObject action:(SEL)anAction;
- setUpTarget:anObject action:(SEL)anAction isContinuous:(BOOL)flag;
- setMax:(double)max allowHigher:(BOOL)hi min:(double)min allowLower:(BOOL)lo;
- setAltStep:(double)step whole:(BOOL)flag default:(double)value;
- setFormat:(BOOL)flag left:(unsigned)l right:(unsigned)r;

 // historical smaller ones:
- setDefault:(double) def;
- setUpTarget:anObject;
- setUpAction:(SEL)anAction;

 // archive methods:   
- read:(NXTypedStream *)stream;
- write:(NXTypedStream *)stream;


 // UNDO methods
- setLastThing:(int)thing;		// we call this before doing anything
- undo;							// we will know how to restore field and 
- _sendSetLastThing;			// set old value before changing
- setUndoTarget:targ tag:(int)pos;  // else client object handles it

 // Misc and private:
- _sendIt;						// to send upAction to upTarget
- (BOOL) isDecimal;
- textPal;
- setTextPal:anObject;			// connect to textField in IB

@end
