
/* Generated by Interface Builder */
#import <appkit/NXImage.h>
#import "ClockView.h"

@implementation ClockView

- initFrame:(NXRect *)frameRect
{
    [super initFrame:frameRect];
    clockImage = [NXImage findImageNamed:"Clock"];
    
    numbers[0] = [NXImage findImageNamed:"DigitalZero"];
    numbers[1] = [NXImage findImageNamed:"DigitalOne"];
    numbers[2] = [NXImage findImageNamed:"DigitalTwo"];
    numbers[3] = [NXImage findImageNamed:"DigitalThree"];
    numbers[4] = [NXImage findImageNamed:"DigitalFour"];
    numbers[5] = [NXImage findImageNamed:"DigitalFive"];
    numbers[6] = [NXImage findImageNamed:"DigitalSix"];
    numbers[7] = [NXImage findImageNamed:"DigitalSeven"];
    numbers[8] = [NXImage findImageNamed:"DigitalEight"];
    numbers[9] = [NXImage findImageNamed:"DigitalNine"];
    
    colon = [NXImage findImageNamed:"Colon"];
    amImage = [NXImage findImageNamed:"AM"];
    pmImage = [NXImage findImageNamed:"PM"];
    
    hours = 10;
    minutes = 2;
    meridianImage = amImage;
    
    return self;
}

- setHour:sender
{
    hours = [sender intValue];
    [self display];
    return self;
}

- setMinutes:sender
{
    minutes = [sender intValue];
    [self display];
    return self;
}

- drawSelf:(NXRect *)rects :(int)count
{
    NXPoint	position;
    NXSize	size, hoursTensSize, hoursUnitsSize, colonSize, minutesTensSize, minutesUnitsSize;
    float	width, timeWidth;
    
    [clockImage composite:NX_COPY toPoint:&(bounds.origin)];
  
    [meridianImage getSize:&size];
    width = position.x = bounds.size.width - size.width - 3.0;
    position.y = (bounds.size.height - size.height) / 2.0;
    [meridianImage composite:NX_COPY toPoint:&position];
    
    if (hours / 10) {
      [numbers[hours / 10] getSize:&hoursTensSize];
      timeWidth = hoursTensSize.width;
    }
    
    [numbers[hours % 10] getSize:&hoursUnitsSize];
    timeWidth += hoursUnitsSize.width;
    [colon getSize:&colonSize];
    timeWidth += colonSize.width;
    [numbers[minutes / 10] getSize:&minutesTensSize];
    timeWidth += minutesTensSize.width;
    [numbers[minutes % 10] getSize:&minutesUnitsSize];
    timeWidth += minutesUnitsSize.width;
    
    position.x = (bounds.size.width - 6.0 - width) / 2.0 + 3.0;
    position.y = 3.0; 
    
    if (hours / 10) {
      [numbers[hours / 10] composite:NX_COPY toPoint:&position];
      position.x += hoursTensSize.width;
    }
    [numbers[hours % 10] composite:NX_COPY toPoint:&position];
    position.x += hoursUnitsSize.width;
    [colon composite:NX_COPY toPoint:&position];
    position.x += colonSize.width;
    [numbers[minutes / 10] composite:NX_COPY toPoint:&position];
    position.x += minutesTensSize.width;
    [numbers[minutes % 10] composite:NX_COPY toPoint:&position];
    
    return self;
}

@end
