
// ColumnMatrix.h --

#import <appkit/Text.h>
#import <objc/List.h>
#import "IconColumnCell.h"
#import "Item.h"

#import <libc.h>
#import <appkit/nextstd.h>

#import <appkit/Matrix.h>

#import "HashList.h"

@interface ColumnMatrix:Matrix
{
  int		numColumns;
  int		numBitmaps;
  float		tabs[MAX_COLUMNS];
  float		realTabs[MAX_COLUMNS];
  
  int		realSelectedRow;
  IconColumnCell *realSelectedCell;
  BOOL		refreshTarget;
@public
  HashList	*itemsList;
  int		firstSelectedRow, lastSelectedRow;
}

+ newFrame:(const NXRect *)frameRect;
- (BOOL)acceptsFirstResponder;
- calcTabs;

- updateCells;
/* checks the visibility of all cells, redraws */
- setCell:aCell fromItem:item;
/* links a cell with a visible item */
- (BOOL)itemVisible:item;
/* rewritten in subclasses to determine if an item is visible */
- setCellCount:(int)newCount;
- empty;

- sendAction:(SEL)theAction to:theTarget;

- selectUp:sender;
- selectDown:sender;
- selectWayUp:sender;
- selectWayDown:sender;


@end
