// IconColumnCell.m -
//
//

#import "IconColumnCell.h"

@implementation IconColumnCell

- drawInside:(const NXRect *)cellFrame inView:controlView
{
  int		i;
  float		x, xOff = cellFrame->size.height - 4.0;
  NXSize	size;
  NXPoint	point;
  NXRect	rect;
  
  [super drawInside:cellFrame inView:controlView];
  
  for (i = 0, x = xOff; i<numBitmaps; i++, x += xOff) {
    if (bitmap[i] != nil) {
      [bitmap[i] getSize:&size];
      point.x = (float)floor((double)cellFrame->origin.x
      			+ x - size.height/2.0);
      point.y = (float)floor((double)cellFrame->origin.y
      			+ cellFrame->size.height/2.0 - size.height/2.0);
      
      [bitmap[i] composite:NX_SOVER toPoint:&point];
#ifdef stupid
      [bitmap[i] composite:NX_HIGHLIGHT toPoint:&point];
      if (cFlags1.highlighted) {
        rect.origin.x = point.x; rect.origin.y = point.y;
	rect.size.width = size.width; rect.size.height = size.height;
	NXHighlightRect(&rect);
      }
#endif
    }
  }
      
  return self;
}


- setAux:(id)newAux
{
  aux = newAux;
  [self setDataNoCopy: aux->cellStrings];
  bitmap = aux->cellBitmaps;
}

- aux
{
  return aux;
}

- setNumBitmaps:(int)num
{
  numBitmaps = num;
}
@end
