
// NewsController.m -


#import "NewsController.h"

@implementation NewsController


- run
{
  [self setDelegate:self];
  return [super run];
}

- appDidInit:sender;
{
  NXSize			contentSize;
  NXRect			matrixRect;
  char				serverName[BUFFER_SIZE];
  static NXDefaultsVector	myDefaults = {
				  {NEWS_HOST, NNTPSERVER},
				  {NULL}
				};


  if (getenv(NNTP_SERVER))
    myDefaults[0].value = getenv(NNTP_SERVER);

  NXRegisterDefaults([NXApp appName], myDefaults);

  strcpy(serverName, NXGetDefaultValue([NXApp appName], NEWS_HOST));
  
  while (![self openServer:serverName]) {
    [NXApp terminate:self];		// get another server
  }

  // newsgroupsMatrix
  // set docView to Matrix, free old one
  [[newsgroupsScrollView setDocView:newsgroupsMatrix] free];
  [newsgroupsScrollView setDocCursor:NXArrow];

  [newsgroupsMatrix readNewsrc];
  [newsgroupsMatrix setupNNTP:nntpFile];


  // articlesMatrix
  // set docView to Matrix, free old one
  [[articlesScrollView setDocView:articlesMatrix] free];
  [articlesScrollView setDocCursor:NXArrow];

  [articlesMatrix setupNNTP:nntpFile];


  // articleDisplay
  [articleDisplay setupNNTP:nntpFile];

  return self;
}

- terminate:sender
{
  [newsgroupsMatrix writeNewsrc];
  return [super terminate:sender];
}

- openServer:(const char *)serverName
{
  int			nntpSocket;
  struct servent	*nntpEnt;
  struct protoent	*nntpProtoEnt;
  struct hostent	*nntpHost;
  struct sockaddr_in	nntpServer;
  //
  int inCode;
  char inCodeText[512];

  if ((nntpEnt = getservbyname("nntp", "tcp")) == NULL) {
    NXRunAlertPanel("News Flash",
		"Cannot find nntp service in 'services' database.",
		NULL, NULL, NULL);
    return nil;
  }

  if ((nntpProtoEnt = getprotobyname(nntpEnt->s_proto)) == NULL) {
    NXRunAlertPanel("News Flash", "Cannot lookup protocol type.",
		NULL, NULL, NULL);
    return nil;
  }

  if ((nntpSocket = socket(AF_INET, SOCK_STREAM, nntpProtoEnt->p_proto))== -1){
    NXRunAlertPanel("News Flash", "Cannot create socket to news server.",
		NULL, NULL, NULL);
    return nil;
  }

  if ((nntpHost = gethostbyname(serverName)) == NULL) {
    NXRunAlertPanel("News Flash", "Cannot find address of host %s.",
		NULL, NULL, NULL, serverName);
    return nil;
  }

  nntpServer.sin_family = nntpHost->h_addrtype;
  bcopy(nntpHost->h_addr, &nntpServer.sin_addr, nntpHost->h_length);
  nntpServer.sin_port = nntpEnt->s_port;
  if ((connect(nntpSocket, (struct sockaddr *) &nntpServer,
	sizeof(nntpServer))) == -1) {
    NXRunAlertPanel("News Flash", "Cannot connect to news server on %s.",
		NULL, NULL, NULL, serverName);
    return nil;
  }

  nntpFile = fdopen(nntpSocket, "r+");

  fscanf(nntpFile, "%d %[^\r]\r", &inCode, &inCodeText);
  fgetc(nntpFile);
  fseek(nntpFile, (long)0, SEEK_END);

  switch (inCode) {
    case OK_CANPOST:
    case OK_NOPOST:
      canPost = (inCode == OK_CANPOST);
      break;
    default:
      NXRunAlertPanel("News Flash", "News server on %s responded incorrectly.",
		NULL, NULL, NULL, serverName);
      return nil;
      break;
  }

  return self;
}


- setNewsgroupsScrollView:anObject
{
  newsgroupsScrollView = anObject;
  return self;
}
- setArticlesScrollView:anObject
{
  articlesScrollView = anObject;
  return self;
}
- setNewsgroupsMatrix:anObject;
{
  newsgroupsMatrix = anObject;
  return self;
}
- setArticlesMatrix:anObject;
{
  articlesMatrix = anObject;
  return self;
}
- setArticleDisplay:anObject
{
  articleDisplay = anObject;
  return self;
}

@end
