
// Newsgroup.h


#import <objc/Storage.h>

#import "config.h"
#import "response_codes.h"

#import <appkit/nextstd.h>
#import <math.h>

#import "IconColumnCell.h"

typedef enum {
  NEWSGROUP_UNSUBSCRIBED, NEWSGROUP_MODERATED, NEWSGROUP_UNSEEN,
  NEWSGROUP_NUM_BITMAPS
} newsgroupBitmapPositions;

typedef enum {
  NEWSGROUP_MESSAGES, NEWSGROUP_NAME, NEWSGROUP_PURPOSE,
  NEWSGROUP_NUM_COLUMNS
} newsgroupStringPositions;

#define	NEWSGROUP_TAB_0		0.13
#define NEWSGROUP_TAB_1		0.26
#define NEWSGROUP_TAB_2		0.90

typedef struct {
  long	first, last;
} seenStruct;

#import "Item.h"

@interface Newsgroup:Item
{
@public
  Storage	*seenStorage;
  // news dependent
  BOOL		moderated;
  seenStruct	available;
  // user dependent
  BOOL		subscribed;
  long		newMessages;
  char		newMessagesString[20]; // fix
}

+ new;
+ newName:(const char *)newName subscribed:(BOOL)newSubscribed;

+ newFromNewsrc:(NXStream *)newsrcStream;

- writeToNewsrc:(NXStream *)newsrcStream;

- (BOOL)selectOnNNTP:(FILE *)nntpFile;

- addSeenFirst:(long)first last:(long)last;
- removeSeenFirst:(long)first last:(long)last;

- setModerated:(BOOL)newModerated;
- (BOOL)moderated;

- setAvailableFirst:(long)newFirst last:(long)newLast;
// - availableFirst:(long *)first last:(long *)last;

- calcNewMessages;
- (long)newMessages;


- setSubscribed:(BOOL)newSubscribed;
- (BOOL)subscribed;

@end
