:
#!/bin/sh
# @(#)conf/lib/inst.sh	1.2 24 Oct 1990 05:16:04
# Install a file under a list of names.
#
# usage: sh inst.sh [-lsr] [-u user] [-g group] [-m mode] [-d dir] src [dst...]
#
#    Copyright (C) 1987, 1988 Ronald S. Karr and Landon Curt Noll
# 
# See the file COPYING, distributed with smail, for restriction
# and warranty information.

# Note: if -d dir is specified, then the first dst should be a relative
#	pathname.

# Don't use getopt(1), as we can't rely on it being built yet, or
# existing on the system.
usage="Usage: inst [-lsr] [-u user] [-g group] [-m mode] [-d dir] src [dst...]"
user=
group=
mode=
symlink=
strip=
rm_old=
err=0
dstpfx=
dbg=

# put /etc into path for chmod
PATH="$PATH:/etc"

# Note:  this shell script uses case rather than test to prevent
#	 a fork/exec on systems where test is not a builtin.

# process the list of options.
# Note:  the option letters and option arguments must be separate tokens.
while : ; do
	case $# in
	0)	break;
	esac
	case "$1" in
	--)	shift; break;;
	-[ugmd])case $# in
		1)	err=1;;
		esac
		case "$1" in
		-u)	user="$2";;
		-g)	group="$2";;
		-m)	mode="$2";;
		-d)	dstpfx="$2/";;
		esac
		shift; shift;;
	-l)	symlink=true; shift;;
	-s)	strip=true; shift;;
	-r)	rm_old=true; shift;;
	-D)	dbg=echo; shift;;
	-*)	err=1; break;;
	*)	break;
	esac
done

# There must be more than one operand.
case $# in
0|1)	err=1;;
esac

# If an error occured, spit out a usage message.
case "$err" in
1)	echo "$usage" 1>&2
	exit 1;;
esac

# The source file is the first operand.
srcfile="$1"; shift

# When using symlinks, copy to the first dstfile, then make all
# the others a symlink to that one.
case "$symlink" in
?*)	dstfile="$1"; shift

	dst="$dstpfx$dstfile"
	new="$dst.NEW"
	old="$dst.OLD"

	# link the old one to a .OLD file
	$dbg rm -f "$old" "$new"
	$dbg ln "$dst" "$old" 2> /dev/null

	# copy to a .NEW and setup the ownerships and permissions
	if $dbg cp "$srcfile" "$new"; then
		:
	else
		$dbg rm -f "$old"
		echo "inst: could not copy to $new" 1>&2
		exit 1
	fi
	case "$strip" in
	?*)	strip "$new";;
	esac
	case "$user" in
	?*)	if $dbg chown "$user" "$new"; then
			:
		else
			$dbg rm -f "$new" "$old"
			echo "inst: failed to change owner of $new" 1>&2
			exit 1
		fi;;
	esac
	case "$group" in
	?*)	if $dbg chgrp "$group" "$new"; then
			:
		else
			$dbg rm -f "$new" "$old"
			echo "inst: failed to change group of $new" 1>&2
			exit 1
		fi;;
	esac
	case "$mode" in
	?*)	if $dbg chmod "$mode" "$new"; then
			:
		else
			$dbg rm -f "$new" "$old"
			echo "inst: failed to change mode of $new" 1>&2
			exit 1
		fi;;
	esac

	# the < /dev/null should work like the -f flag to mv,
	# even for systems that don't have it.
	if $dbg mv "$new" "$dst" < /dev/null; then
		echo "$srcfile installed as $dst"
	else
		$dbg rm -f "$new" "$old"
		echo "inst: failed to install $srcfile as $dst" 1>&2
		exit 1
	fi

	# if -r flag specified, remove the .OLD file
	case "$rm_old" in
	?*)	rm -f "$old";;
	esac

	# loop through the remaining operands.
	while : ; do
		case "$#" in
		0)	break;;
		esac
		case "$1" in
		/*)	$dbg rm -f "$1"
			if $dbg ln -s "$dst" "$1"; then
				echo "$dst symlinked to $1"
			else
				echo "inst: symlink failed for $1" 1>&2
				err=1
			fi;;
		*)	$dbg rm -f "$dstpfx$1"
			if $dbg ln -s "$dstfile" "$dstpfx$1"; then
				echo "$dstfile symlinked to $dstpfx$1"
			else
				echo "inst: symlink failed for $dstpfx$1" 1>&2
				err=1
			fi;;
		esac
		shift
	done
	exit $err
	;;
esac

# when not using symbolic links, create the first dst, then try to
# make each successive dst a hard link to the previous.  If the hard
# link fails, then copy, creating a backup file as needed.
lastdst=

while : ; do
	case $# in
	0)	break;;
	esac
	case "$1" in
	/*)	dst="$1";;
	*)	dst="$dstpfx$1";;
	esac
	shift
	new="$dst.NEW"
	old="$dst.OLD"

	case "$lastdst" in
	?*)	# link to previous
		$dbg rm -f "$new" "$old"
		$dbg ln "$dst" "$old" 2> /dev/null
		if $dbg ln "$lastdst" "$new" 2> /dev/null &&
		   $dbg mv "$new" "$dst" < /dev/null
		then
			echo "$lastdst linked to $dst"
			case "$rm_old" in
			?*)	rm -f "$old";;
			esac
			lastdst="$dst"
			continue
		fi;;
	*)	# copy
		$dbg rm -f "$new" "$old"
		$dbg ln "$dst" "$old" 2> /dev/null;;
	esac

	# copy to the current destination
	lastdst=

	if $dbg cp "$srcfile" "$new"; then
		:
	else
		echo "inst: could not copy to $new" 1>&2
		err=1
		continue
	fi
	case "$strip" in
	?*)	strip "$new";;
	esac
	case "$user" in
	?*)	if $dbg chown "$user" "$new"; then
			:
		else
			$dbg rm -f "$new" "$old"
			echo "inst: failed to change owner of $new" 1>&2
			err=1
			continue
		fi;;
	esac
	case "$group" in
	?*)	if $dbg chgrp "$group" "$new"; then
			:
		else
			$dbg rm -f "$new" "$old"
			echo "inst: failed to change group of $new" 1>&2
			err=1
			continue
		fi;;
	esac
	case "$mode" in
	?*)	if $dbg chmod "$mode" "$new"; then
			:
		else
			$dbg rm -f "$new" "$old"
			echo "inst: failed to change mode of $new" 1>&2
			err=1
			continue
		fi;;
	esac

	# the < /dev/null should work like the -f flag to mv,
	# even for systems that don't have it.
	if $dbg mv "$new" "$dst" < /dev/null; then
		echo "$srcfile installed as $dst"
	else
		$dbg rm -f "$new" "$old"
		echo "inst: failed to install $srcfile as $dst" 1>&2
		err=1
		continue
	fi
	lastdst="$dst"

	# if -r flag specified, remove the .OLD file
	case "$rm_old" in
	?*)	rm -f "$old";;
	esac
done

exit $err
