Part 11:  Utilities.

	This part gives an overview of the various utilities that come
	with smail.  Each of the utilities is listed below, followed by
	a short description.  Some utilities are actually built into
	the smail program and are accessed by calling the smail program
	under a different name; such utilities are noted.

	NOTE:  most of the addressing examples are from namei.  Namei
	       has a connection with amdahl, glotz and walldrug.
	       To add spice to the discussion a fourth link, to clyde
	       in att.com, will be assumed.


Section 11.1:  Path tools.

	Smail has a number of path computation tools to allow the
	nieve as well as the experienced user to explore paths
	and to understand what the smail mailer will to with an address.


Section 11.1.1:  The uupath command.

    uupath [ -s ] domain ...	(builtin)
	Produces on the output a pure !-route containing the hosts and
	domains to be traversed in sending mail destined for a given host
	or domain.  The host or domain may be specified as an address, in
	that case a !-route is found to the first host in the address and
	the rest of the hosts in the address are appended in !-route form.
	The returned string will end in %s, for historical reasons.

	NOTE:  if the flag -s is given, smart-host routing may be used,
	       otherwise it will not be.

	Examples:
		$ uupath neptune
		uupath: no route found to neptune

		$ uupath neptune.att.com
		amdahl!cbosgd!neptune.att.com!%s

		$ uupath namei cbosgd!cbatt
		%s
		amdahl!cbosgd!cbatt!%s


Section 11.1.2:  The pathto command.

    pathto [ -sn ] addr ...	(builtin)
	Given an address, pathto returns a pure !-route which will deliver
	to that address.  If the -n flag is given then the address may not
	be a pure !-route, but will be acceptible as an address argument
	to the smail program.  As with uupath, -s means don't do smart-host
	routing.

	Examples:
		$ pathto -n postmaster@uts.amdahl.com tron
		@amdahl:postmaster@uts.amdahl.com
		tron@namei.uucp

		$ pathto @sun.com,@seismo.css.gov:rick@uunet.uu.net
		amdahl!sun!seismo.css.gov!uunet.uu.net!rick

		$ pathto lda@clyde.att.com mit-athena unknown-hostname
		clyde!lda
		namei!mit-athena
		pathto: no route found to unknown-hostname


Section 11.1.3:  The optto command.

    optto [-sn] addr ...	(builtin)
	Given an address, try to find an optimal form for that address.
	This is done by reparsing address for hosts or domains and
	computing routes until a host/domain cannot be routed to or
	no more exist in the address.  Then print the address that
	represented the smallest amount of traversed domains.  If -s
	is specified then use the smart-host router only if there is
	no route for the first domain.

	Examples:
		$ optto -n @berkeley.edu,@cbosgd:root@neptune
		@amdahl,@cbosgd:root@neptune

		$ optto sun!seismo!cbatt!amdahl!namei!tron
		tron


Section 11.2:  Pathalias map tools.

	The pathalias program reads maps the as the USENET maps
	as posted to the ``comp.mail.maps'' newsgroup and converts
	then into optimized routes to sites from the local site.
	These collection of tools allow one to build and querry
	this map database.  The route tables produced by these
	programs are suitable to use by the pathalias router
	driver.  See Section 6.3.1 for details.


Section 11.2.1:  The pathalias command.

    pathalias args ...
	By Steve Bollin, as told to Peter Honeyman.  The pathalias
	program takes map information on input and produces pathalias
	routing data on output.

	Examples:
		$ echo "namei: amdahl, clyde" | pathalias
		namei	%s
		amdahl	amdahl!%s
		clyde	clyde!%s


Section 11.2.2:  The uuwhere command.

    uuwhere host ...
	Return the map file names associated with the given hosts.

	Examples:
		$ uuwhere namei cbosgd black-n-decker
		/usr/spool/uumaps/u.usa.ca.2
		/usr/spool/uumaps/u.usa.oh.1
		uuwhere: black-n-decker not found in uuwhere database


Section 11.2.3:  The getmap command.

    getmap [ directory ]
	Takes on standard input a shell archive containing map data,
	as distributed in the USENET comp.mail.maps newsgroup.  The
	map data is installed as files in the given directory.  If
	no directory is specified a site-dependent default is assumed.


Section 11.2.4:  The mkmap command.

    mkmap [ -p pathfile ] [ -w wherefile ] [ directory ... file ... ]
	Builds the pathalias database and uuwhere database either on
	the given pathfile and wherefile or in site-dependent default
	locations.  The directories will be searched for path files
	and the files will be taken as pathfiles and the entire mess
	run through pathalias, and through a where building program.


Section 11.2.5:  The uuwho command.

    uuwho host ...
	Display map data for the given hosts.  The map data is generally
	the collection of maps sent over USENET containing pathalias
	input for all sites that send such information into the map
	coordinators.

	Example:
		$ uuwho namei
		#N	namei
		#S	Symmetric S/375; 4.2BSD UN*X
		#O	Positron
		#C	Ronald S. Karr
		#E	namei!postmaster
		#T	+1 408 746 7288
		#P	3770 Flora Vista, suite 1806, Santa Clara CA  95051
		#L	37 20 49 N / 121 59 26 W
		#U	amdahl walldrug bats
		#W	namei!tron; Fri Aug 14 23:56:53 PDT 1987
		namei	amdahl(HOURLY+HIGH), walldrug(HOURLY), glotz(LOCAL)

	NOTE:  The degree of output formatting may vary.


Section 11.3:  Database building tools

CHONGO: to be written


Section 11.3.1:  mkdbm

    mkdbm [ -fvnd ] [ -o output-name ] [  file ...  ]
	Mkdbm takes  lines as input and writes  them  to  a  set  of
	files  in  the  format  produced  by  the  dbm(3X)  function
	library.  The key is formed from the characters up  to,  but
	not  including,  a  colon  (``:'') or white space character.
	The data after the colon or white space character forms  the
	value  associated  with the key.  If -f is given, the key is
	folded to lower case before being stored in the database.

	If no input files are specified, the standard input is read.
	In addition, if a filename of - is given, the standard input
	is inserted at that point.

	The -o option sets the name for the DBM  database.   If  not
	specified explicitly, the name of the database is taken from
	the first file argument.  If no file arguments are given, or
	the  first  such argument is - then the name of the database
	will be dbm.

	The mkdbm program can be used to produce DBM files which can
	then  be  read  by  a smail(8) pathalias router or aliasfile
	director.  The router or directory should be  configured  to
	use  the  dbm  file  access protocol.  See smail(5) for more
	information on routers and directors.  For  some  databases,
	mkline(1)  should  be  used to form single line records with
	comments and extra white-space removed.

	The generated database contains a single nul byte at the end
	of  each  key  and  value.   Also a single record containing
	``@'' as a key and value is created for  compatibility  with
	the  Berkeley sendmail(8) program's alias files.  The ending
	nul bytes can be suppressed with  the  -n  option,  and  the
	extra  ``@''  record  can  be suppressed with the -d option.
	Use of -n is incompatible with the  smail  dbm  file  access
	method.

	When creating the database, temporary DBM files are built in
	the same directory as the eventual output files.  Then, when
	it is completed, any DBM files currently existing under  the
	target  name  are  removed, mkdbm sleeps between one and two
	seconds, and then the temporary DBM files are moved  to  the
	target names.  This database creation method is not compati-
	ble with the locking method used by Berkeley sendmail.

	If the -v flags is specified mkdbm writes statistics to  the
	standard output after the database has been built.

	containing the routing information:

	     .COM           sun!%s
	     Stargate.COM   ames!cmcl2!uiucdcs!stargate!%s
	     ames           ames!%s
	     .ATT.COM       mtune!%s
	     mtune          mtune!%s

	Given this file, the command mkdbm -f paths will  produce  a
	dbm database in the files paths.pag and paths.dir containing
	the above entries, with downcased keys.   For  example,  one
	entry  will  contain the key stargate.com with an associated
	value of ames!cmcl2!uiucdcs!stargate!%s.


Section 11.3.2:  mkhash

CHONGO: to be written


Section 11.3.3:  mksort

    mksort [ -f ] [ file ...  ]
	Mksort takes lines as input, sorts them and writes  them  to
	the  standard  output.   The  lines can be of any length, as
	long as the entire input can be stored in memory.   With  -f
	the  sort  is  performed  independent  of  case, so that the
	letter ``A'' compares equal to the letter ``a'' and ``a'' is
	always less than ``B.''

	If no input files are specified, the standard input is read.
	In addition, if a filename of - is given, the standard input
	is inserted at that point.

	The mksort program can be used in combination with mkline(1)
	to produce sorted files containing arbitrarily large aliases
	or paths which can then be  read  by  a  smail(8)  pathalias
	router or aliasfile director.  The router or director should
	be configured to use the bsearch file access protocol.   See
	smail(5) for more information on routers and directors.

	As an example of the use of mksort with  mkline  consider  a
	file,  aliases,  containing  the following aliasing informa-
	tion:

	     Postmaster:       hustead               # Ted Hustead, jr.
	     UUCP-Postmasters: tron, chongo          # namei contacts
	                       yamato                # kremvax contact
	     tron:             tron@namei.uucp (Ronald S. Karr)
	     yamato:           yamato@kremvax.ussr.comm (Yamato T. Yankelovich)
	     chongo:           chongo@eek.uts.amdahl.com (Landon Curt Noll)

	Given this file, the command mkline aliases | mksort -f will
	yield:

	     chongo:chongo@eek.uts.amdahl.com
	     Postmaster:hustead
	     tron:tron@namei.uucp
	     UUCP-Postmasters:tron,chongo yamato
	     yamato:yamato@kremvax.ussr.comm


Section 11.3.4:  mkline

    mkline [ -l ] [ file ...  ]
	Mkline takes alias files, path files or mailing  list  files
	as input and produces output records containing one complete
	entry per line with all comments and whitespace replaced  by
	zero  or one spaces.  One space is used if the concatenation
	of two tokens would otherwise cause ambiguity.  For  mailing
	lists,  the  -l flag should be specified and the output will
	be a list of addresses.  Otherwise, the input is assumed  to
	be  alias  files or path files and the output is single line
	entries, with the key always separated from the  data  by  a
	single colon character (``:'').

	If no input files are specified, the standard input is read.
	In addition, if a filename of - is given, the standard input
	is inserted at that point.


	     Postmaster:       hustead               # Ted Hustead, jr.
	     UUCP-Postmasters: tron, chongo          # namei contacts
	                       yamato                # kremvax contact
	     tron:             tron@namei.uucp (Ronald S. Karr)
	     yamato:           yamato@kremvax.ussr.comm (Yamato T. Yankelovich)
	     chongo:           chongo@eek.uts.amdahl.com (Landon Curt Noll)

	then the command mkline aliases will produce:

	     Postmaster:hustead
	     UUCP-Postmasters:tron,chongo yamato
	     tron:tron@namei.uucp
	     yamato:yamato@kremvax.ussr.comm
	     chongo:chongo@eek.uts.amdahl.com

	As an example of using mkline  to  compress  mailing  lists,
	consider the mailing list:

	     tron@namei.uucp,tron@uts.amdahl.com     # Ronald S. Karr
	     yamato@kremvax.ussr.comm                # Yamato T. Yankelovich
	     chongo@eek.uts.amdahl.com               # Landon Curt Noll
	     Wilt . (the Stilt) Chamberlain@NBA.US   # RFC822 doc example

	The command mkline -l applied to this list will produce:

	     tron@namei.uucp
	     tron@uts.amdahl.com
	     yamato@kremvax.ussr.comm
	     chongo@eek.uts.amdahl.com
	     Wilt.Chamberlain@NBA.US


Section 11.3.5:  mkblob

TRON: to be updated and expanded?

    mkblob -f [ startup ] [ config ]
	Given a config file, generate a startup file and place it under
	the given startup file name or under in the default place for
	the startup file.  If no config file is given, then look for the
	config file in the default place.


Section 11.4:  Mailing list tools.

CHONGO: add section about tools that add, modify, remove names
	from mailing lists

