/*****************************************************************************/
/* DecodeGIF.h								     */
/* interface file of DecodeGIF class of ViewGif2 application		     */
/* January 1990  Carl F. Sutter						     */
/*****************************************************************************/

#import <objc/Object.h>
#import "Animator.h"
#import <appkit/Bitmap.h>

/* some global data types and constants */
#define	BYTE unsigned char
#define	WORD unsigned short
#define	MAXCOLORS  256
#define	RGB	     3

#define STATUS_OPEN		100
#define STATUS_GLOBAL		101
#define STATUS_BLOCK		102
#define STATUS_IMAGE		103
#define STATUS_DECODING		104
#define STATUS_EXTENSION	105
#define STATUS_DONE		106

@interface DecodeGIF:Object
   {
   // outlets
   id	decodePanel;			// decoding status panel
   id	gauge;				// time left gauge
   id	width;				// width display text field
   id	height;				// height...
   id	numColors;			// number of colors...
   id	filename;			// current file name being decoded
   
   // internal instance variables
   id		target;			// object to notify when decoding is done
   SEL 		action;			// method to perform for above
   char		szFileName[40];		// name of file currently decoded
   char		szPathName[160];	// full path name of file currently decoded
   Animator	*timer;			// Instance of Animator object
   NXStream	*stream;		// file stream of GIF file data
   
   int		nStatus;		// current decoding status
   int		nWidth;			// current image width
   int		nHeight;		//    "      "   height
   int		nNumColors;		// number of colors in current image
   BYTE		byColorMap[MAXCOLORS * RGB];	// color look up table
   int		nBPP;			// bits per pixel
   BOOL		bInterlaced;		// interlaced or not
   BYTE		*byDataR;		// Red   data array to hold image bytes
   BYTE		*byDataG;		// Green data array to hold image bytes
   BYTE		*byDataB;		// Blue  data array to hold image bytes
   BOOL		bDecoding;		// flag for currently LZW decoding status
   Bitmap	*bmpOut;		// decoded, imaged bitmap result
   }

// factory methods
+ new;
+ new:(id )targ action:(SEL )act; 

// outlet initialization methods
- setDecodePanel:anObject;
- setGauge:anObject;
- setWidth:anObject;
- setHeight:anObject;
- setNumColors:anObject;
- setFilename:anObject;

// actions
- show:sender;
- setTarget:(id)targ; 
- setAction:(SEL)aSelector; 
- decodeFile:(const char *)fileName;

// internal methods
- setup;
- nextStep:sender;
- (BOOL)openFile;
- (BOOL)readGlobalInfo;
- (BOOL)readMap;
- (BOOL)readBlockCode;
- (BOOL)readImageInfo;
- (BOOL)startDecoder;
- (BOOL)finishDecoder:(long)lReturnCode;
- (BOOL)readBytes:(int)nNumBytes data:(void *)buf;
- errorAlert:(char *)szMessage;
- sucessfulDecoding;
- cancelDecoding;


@end
