/*
 * transform.h
 *
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 * $Id$
 *
 * $Log$
 */
#ifndef TRANSFORM_H
#define TRANSFORM_H

/*
 * Transformation 'matrix'.
 */
typedef struct Matrix {
	Float matrix[3][3];		/* Rotation matrix */
	Vector translate;		/* Translation */
} Matrix;

/* 
 * Transformation structure
 */
typedef struct Trans {
	Matrix  trans,	/* object space --> world space */
		itrans;	/* worldspace --> object space */
} Trans;

extern void	MatrixMult(), MatrixCopy(), MatrixInit(), MatrixInvert(),
		TransCopy(), TransInit(), TransInvert(),
		TransCompose(),
		VecTransform(), PointTransform(), NormalTransform();

extern Trans	*TransCreate(), *CoordSysTransform();

extern Matrix	*MatrixCreate(), *RotationMatrix(), *TranslationMatrix(),
		*ScaleMatrix(), *ArbitraryMatrix();

extern Float	RayTransform();

#endif /* TRANSFORM_H */
