/*
 * surface.h
 *
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 * $Id$
 *
 * $Log$
 */
#ifndef SURFACE_H
#define SURFACE_H

#define DEFAULT_INDEX		1.0	/* Default index of refraction */

/*
 * Surface definition.
 */
typedef struct Surface {
	char	*name;			/* Name */
	char	noshadow;		/* No shadows flag */
	struct Color	amb,		/* Ambient color */
			diff,		/* Diffuse color */
			spec;		/* Specular color */
	Float	coef,			/* Phong shading coef. */
		refl,			/* Reflectivity */
		transp,			/* Transparency */
		kref,			/* Index of refraction */
		translucency,		/* translucency (0-1) */
		stcoef;			/* Phong coef. for transmitted light */
	struct Atmosphere *atmos;	/* Atmospheric effects */
	struct Surface *next;		/* Next surface in list (if any) */
} Surface;

/*
 * Linked list of (linked list of) surfaces.
 */
typedef struct SurfList {
	Surface *surf;
	struct SurfList *next;
} SurfList;

extern Surface	*SurfaceCreate(),
		*GetShadingSurf(),	/* application-provided */
		*SurfaceCopy();

extern SurfList	*SurfPop(), *SurfPush();

extern void	SurfaceBlend(), ColorBlend();

extern int	ComputeSurfProps();

#endif /* SURFACE_H */
