/* input_lex.l								   */
/* Copyright (C) 1989, 1991, Craig E. Kolb				   */
/* All rights reserved.							   */
/*									   */
/* This software may be freely copied, modified, and redistributed,	   */
/* provided that this copyright notice is preserved on all copies.	   */
/*									   */
/* You may not distribute this software, in whole or in part, as part of   */
/* any commercial product without the express consent of the authors.	   */
/* 									   */
/* There is no warranty or other guarantee of fitness of this software	   */
/* for any purpose.  It is provided solely "as is".			   */
/*									   */
/* $Id$ */
%{
#include "rayshade.h"
#ifdef index	/* good guess? */
#include <string.h>
#else
#include <strings.h>
#endif
#include <stdlib.h>
#include "libsurf/atmosphere.h"
#include "libsurf/surface.h"
#include "libtext/texture.h"
#include "libobj/object.h"
#include "y.tab.h"
extern char *strsave();
%}
alpha	[a-zA-Z]
special	[\.\_-]
digit	[0-9]
exp	[Ee][-+]?{digit}+
string	"/"?{alpha}({alpha}|{digit}|{special}|"/")*
%p 5000
%%
[ \t\n]			;
^#			handlehash();
"/*"			skipcomments();
adaptive		return tADAPTIVE;
ambient			return tAMBIENT;
aperture		return tAPERTURE;
applysurf		return tAPPLYSURF;
area			return tAREA;
atmosphere		return tATMOSPHERE;
background		return tBACKGROUND;
blob			return tBLOB;
blotch			return tBLOTCH;
body			return tFOG;	/* A synonym for fog */
box			return tBOX;
bump			return tBUMP;
checker			return tCHECKER;
cloud			return tCLOUD;
cone			return tCONE;
component		return tCOMPONENT;
contrast		return tCONTRAST;
cursurf			return tCURSURF;
cutoff			return tCUTOFF;
cylinder		return tCYL;
cylindrical		return tCYLINDRICAL;
diffuse			return tDIFFUSE;
difference		return tDIFFERENCE;
directional		return tDIRECTIONAL;
disc			return tDISC;
end			return tEND;
extended		return tEXTENDED;
eyep			return tEYEP;
eyesep			return tEYESEP;
fbm			return tFBM;
fbmbump			return tFBMBUMP;
focaldist		return tFOCALDIST;
fog			return tFOG;
fov			return tFOV;
gloss			return tGLOSS;
grid			return tGRID;
heightfield		return tHEIGHTFIELD;
image			return tIMAGE;
index			return tINDEX;
intersect		return tINTERSECT;
jittered		return tJITTERED;
light			return tLIGHT;
linear			return tLINEAR;
list			return tLIST;
lookp			return tLOOKP;
map			return tMAP;
marble			return tMARBLE;
maxdepth		return tMAXDEPTH;
mist			return tMIST;
name			return tNAME;
noshadow		return tNOSHADOW;
object			return tOBJECT;
outfile			return tOUTFILE;
plane			return tPLANE;
point			return tPOINT;
poly			return tPOLY;
polygon			return tPOLY;
quiet			return tQUIET;
range			return tRANGE;
reflect			return tREFLECT;
report			return tREPORT;
resolution		return tSCREEN; /* A synonym for screen */
rotate			return tROTATE;
samples			return tSAMPLES;
scale			return tSCALE;
screen			return tSCREEN;
shadowtransp		return tSHADOWTRANSP;
sky			return tSKY;
smooth			return tSMOOTH;
sphere			return tSPHERE;
spherical		return tSPHERICAL;
specular		return tSPECULAR;
specpow			return tSPECPOW;
spot			return tSPOT;
stripe			return tSTRIPE;
surface			return tSURFACE;
textsurf		return tTEXTSURF;
texture			return tTEXTURE;
tile			return tTILE;
torus			return tTORUS;
transform		return tTRANSFORM;
translate		return tTRANSLATE;
translu			return tTRANSLU;
translucency		return tTRANSLU;
transp			return tTRANSP;
triangle		return tTRIANGLE;
triangleuv		return tTRIANGLEUV;
union			return tUNION;
up			return tUP;
uv			return tUV;
verbose			return tVERBOSE;
window			return tWINDOW;
wood			return tWOOD;
{digit}+ |
{digit}+"."{digit}*({exp})? |
{digit}*"."{digit}+({exp})? |
{digit}+{exp}		{yylval.d = atof(yytext); return tFLOAT;}
{string}		{yylval.c = strsave(yytext); return tSTRING;}
.			return yytext[0];

%%
yywrap() {return 1;}
/*
 * Skip over comments.
 */
skipcomments()
{
	char c;

	while (1) {
		while (input() != '*')
			;
		if ((c = input()) == '/')
			return;
		unput(c);
	}
}
/*
 * Deal with ccp-produced lines of the form:
 * # n "filename"
 * and
 * # n
 * Where filename is the name of the file being processed, and n is
 * the current line number in that file.
 */
handlehash()
{
	char buf[BUFSIZ];
	int i;
	extern int yylineno;
	extern char yyfilename[];
	extern void exit();

	/*
	 * Read the entire line into buf.
	 */
	for (i = 0; (buf[i] = input()) != '\n'; i++)
			;
	unput(buf[i]);		/* To make sure consecutive # lines work. */
	buf[i] = (char)NULL;	/* Replace newline with NULL. */

	/*
	 * Complain if the line was not of the form #n "filename"
	 */
	if ((i = sscanf(buf, "%d \"%[^\"]s\"", &yylineno, yyfilename)) == 0) {
		RLerror(RL_PANIC, "Unknown '#' control (%s).",buf);
		exit(1);
	}
	if (i == 1) {
		if (index(buf, '"') != (char *)NULL) {
			/*
			 * Filename was "", which means stdin.
			 */
			(void)strcpy(yyfilename, "stdin");
		}
	}
}
