/*
 * lightdef.c
 *
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 * $Id$
 *
 * $Log$
 */
#include "rayshade.h"
#include "options.h"
#include "liblight/light.h"
#include "liblight/infinite.h"	/* to create default infinite light */

Light *Lights = NULL;		/* Linked list of defined lights */

void
LightAddToDefined(light)
Light *light;
{
	if (light) {
		light->next = Lights;
		Lights = light;
	}
}

void
LightSetup()
{
	long shadowopts;
	Light *ltmp;

	/*
	 * Set shadowing options.
	 */
	shadowopts = 0;
	if (Options.no_shadows)
		shadowopts |= SHADOW_NONE;
	if (Options.shadowtransp)
		shadowopts |= SHADOW_TRANSP;
	if (Options.csg)
		shadowopts |= SHADOW_CSG;
	if (Options.cache)
		shadowopts |= SHADOW_CACHE;
	ShadowSetOptions(shadowopts);

	/*
	 * If no light sources were defined, add a default.
	 */
	if (Lights == (Light *)NULL) {
		Color ctmp;
		Vector vtmp;
		vtmp.x = vtmp.z = 1.;
		vtmp.y = -1;
		ctmp.r = ctmp.g = ctmp.b = 1.;

		LightAddToDefined(LightInfiniteCreate(&ctmp, &vtmp));
	}
	/*
	 * Now that we've parsed the input file, we know what
	 * maxlevel is, and we can allocate the correct amount of
	 * space for each light source's cache.
	 */
	for (ltmp = Lights; ltmp; ltmp = ltmp->next) {
		ltmp->cache = (ShadowCache *)Calloc(
			(unsigned)Options.maxdepth + 1, sizeof(ShadowCache));
	}
}
