/*
 * options.h
 *
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 * $Id$
 *
 * $Log$
 */
#ifndef OPTIONS_H
#define OPTIONS_H

/*
 * Constants for Stereo mode
 */
#define LEFT		1
#define RIGHT		2

/*
 * Options
 */
typedef struct {
	int	stereo,			/* Stereo mode? */
		verbose,		/* Babbling mode? */
		quiet,			/* Don't complain? */
		jittered,		/* Jittered screen sampling? */
		jit_samples,		/* Sqrt of # of jittered samples */
		pixel_div,		/* Max # pixel subdivision */
		maxdepth,		/* Maximum ray tree depth */
		report_freq,		/* Frequency, in lines, of report */
		no_shadows,		/* Trace shadow rays? */
		shadowtransp,		/* ... through transparent objects? */
		cache,			/* Cache shadowing info? */
		appending,		/* Append to image file? */
		resolution_set,		/* resolution set on command line */
		contrast_set,		/* contrast overridden ... */
		samples_set,		/* samples overridden ... */
		cutoff_set,		/* cutoff ... */
		adaptive_set,		/* adaptive sampling ... */
		jittered_set,		/* jittered sampling ... */
		maxdepth_set,		/* adaptive depth ... */
		window_set,		/* window ... */
		freq_set,		/* report frequency ... */
		eyesep_set,		/* eye separation ... */
		csg,			/* CSG object someplace in world */
		flipnorm;		/* flip normals of polygonal objs */
#ifdef URT
	int	alpha;			/* Write alpha channel? */
	int	exp_output;		/* Write exponential RLE file? */
#endif
	Float	cutoff,			/* Min. ray contribution */
		eyesep,			/* Eye separation (for Stereo mode) */
		gamma;			/* Gamma value (0 == no correction) */
	Color	contrast;		/* Max. allowable contrast */
	char	*progname,		/* argv[0] */
		*statsname,		/* Name of stats file. */
		*imgname,		/* Name of output image file */
		*inputname,		/* Name of input file, NULL == stdin */
		*cppargs;		/* arguments to pass to cpp */
#ifdef LINDA
	int	workers,		/* # of worker processes */
		verbose_worker;		/* Babble while you work? */
#endif
	FILE	*pictfile;		/* output file pointer */
} RSOptions;

extern RSOptions Options;
extern void OptionsList(), OptionsSet();

#endif /* OPTIONS_H */
