(when (add ?x ?y ?z))
(how (add ?x ?y ?z) relax-squeeze)

(when (mult ?x ?y ?z))
(how (mult ?x ?y ?z) relax-squeeze)

(when (int ?x))
(how (int ?x) relax-squeeze)

(when (gt ?x ?y))
(how (gt ?x ?y) relax-squeeze)

(when (geq ?x ?y))
(how (geq ?x ?y) relax-squeeze)

(when (neq ?x ?y))
(how (neq ?x ?y) relax-squeeze)

(when (split-abs ?prec ?x))
(how (split-abs ?prec ?x)
	(lambda (goal program s f)
		(arith-debug "in how-split() with goal:")
		(arith-debug (term-instantiate (goal-term goal)))
		(user-debug "just delaying goal")
		(let	((old-split-list (backup-split-list)))
			(flounder! goal)
			(dlist-insert-anywhere! goal SPLITTING-GOALS)
			(s (lambda ()
				(unflounder! goal)
				(restore-split-list! old-split-list)
				(f))))))

(when (split-rel ?prec ?x))
(how (split-rel ?prec ?x)
	(lambda (goal program s f)
		(arith-debug "in how-split() with goal:")
		(arith-debug (term-instantiate (goal-term goal)))
		(user-debug "just delaying goal")
		(let	((old-split-list (backup-split-list)))
			(flounder! goal)
			(dlist-insert-anywhere! goal SPLITTING-GOALS)
			(s (lambda ()
				(unflounder! goal)
				(restore-split-list! old-split-list)
				(f))))))

(when (split-machine ?x))
(how (split-machine ?x)
	(lambda (goal program s f)
		(arith-debug "in how-split() with goal:")
		(arith-debug (term-instantiate (goal-term goal)))
		(user-debug "just delaying goal")
		(let	((old-split-list (backup-split-list)))
			(flounder! goal)
			(dlist-insert-anywhere! goal SPLITTING-GOALS)
			(s (lambda ()
				(unflounder! goal)
				(restore-split-list! old-split-list)
				(f))))))

(when (split ?x))
(how (split ?x)
	(lambda (goal program s f)
		(arith-debug "in how-split() with goal:")
		(arith-debug (term-instantiate (goal-term goal)))
		(user-debug "just delaying goal")
		(let	((old-split-list (backup-split-list)))
			(flounder! goal)
			(dlist-insert-anywhere! goal SPLITTING-GOALS)
			(s (lambda ()
				(unflounder! goal)
				(restore-split-list! old-split-list)
				(f))))))

(when (interval ?term ?lbt ?lb ?ub ?ubt))
(how (interval ?term ?lbt ?lb ?ub ?ubt)
	(lambda (goal program s f)
		(let*	((g-term (goal-term goal))
			(inst-goal (term-instantiate g-term))
			(term (term-deref (comp-cadr g-term))))
			(arith-debug "in interval() with goal:")
			(arith-debug inst-goal)
			(if	(and	(term-var? term) (var-inst? term)
					(arith-interval? (var-val term)))
				(let*	((lbt (comp-caddr g-term))
					(lb (comp-cadddr g-term))
					(ub (comp-caddddr g-term))
					(ubt (comp-cadddddr g-term))
					(val (var-val term))
					(lbt-val (lb-type@ val))
					(lb-val (lb@ val))
					(ub-val (ub@ val))
					(ubt-val (ub-type@ val))
					(u-ub (lambda (f)
						(unify ub ub-val program s f)))
					(u-lb (lambda (f)
						(unify lb lb-val program
							u-ub f)))
					(u-ubt (lambda (f)
						(unify ubt ubt-val program
							u-lb f))))
					(unify lbt lbt-val program u-ubt f))
				(begin	(user-debug "just delaying goal")
					(flounder! goal)
					(var-add-constraint! goal term 'REAR)
					;;; assumes var here!
					(s (lambda ()
						(var-del-constraint! goal term)
						(unflounder! goal)
						(f))))))))

(when (monitor ?x ?item))
(how (monitor ?x ?item)
	(lambda (goal program s f)
		(let*	((g-term (goal-term goal))
			(term (term-deref (comp-cadr g-term)))
			(inst-term (term-instantiate (comp-cadr g-term)))
			(item (term-instantiate (comp-caddr g-term)))
			(inst-goal (term-instantiate g-term)))
			(arith-debug "in monitor() with goal:")
			(arith-debug inst-goal)
			(if	(term-not-var? term)
				(error 'monitor() "illegal term ~s" term))
			(display inst-term)
			(display item)
			(newline)
			(if	(and	(var-inst? term)
					(or	(term-const? (var-val term))
						(and	(arith-interval?
								(var-val term))
							(point? (var-val term)))))
					;;; no more narrowing/squeezing possible
				(s f)
				(begin	(var-add-constraint! goal term 'REAR)
					(flounder! goal)
					(s (lambda ()
						(unflounder! goal)
						(var-del-constraint! goal term)
						(f))))))))
