// My stuff.
#import "Animator.h"
#import "ClockApp.h"
#import "ClockView.h"

// appkit stuff
#import <appkit/defaults.h>		// To get the dang things.
#import <appkit/Control.h>		// To handle initing of dialSize slider.
#import <appkit/Matrix.h>		// To handle initing of type matrix.
#import <appkit/Window.h>		// to blast the window around.

// unix stuff.
#import <stdlib.h>			// atof().

@implementation ClockApp

+ new			// create the new application, and make us its delegate.
{
  self = [super new];
  [self setDelegate:self];
  return self;
}
- setClockView:anObject
{
  clockView=anObject;
  return self;
}
// This is a gross, gross c function.  Positive side - it works!
const char *ftoa( float f)
{
  static char num[ 100];
  sprintf( num, "%f", f);
  return num;
}
- terminate:sender		// store the position and size.
{
  NXRect r;
  // This is stupid.  Need the _window's_ position in screen coordinates,
  // and the _clockView's_ size (no coordinates) to be able to correctly
  // place the window when re-run.  Didn't want to use placeWindow, as
  // sizes and stuff didn't seem to work.
  [[clockView window] getFrame:&r];
  NXWriteDefault( [self appName], "WindowX", ftoa( r.origin.x));
  NXWriteDefault( [self appName], "WindowY", ftoa( r.origin.y));
  [clockView getBounds:&r];
  NXWriteDefault( [self appName], "WindowSize", ftoa( r.size.width));
  NXWriteDefault( [self appName], "DialSize", ftoa( [clockView dialSize]));
  NXWriteDefault( [self appName], "ClockType", ftoa( [clockView clockType]));
  return [super terminate:sender];
}
- appPowerOffIn:(int)ms andSave:(int)aFlag	// catch Workspace logout.
{
  return [self terminate:self];
}

- setDialSizeSlider:anObject
{
  dialSizeSlider=anObject;
  return self;
}
- setTypeMatrix:anObject
{
  typeMatrix=anObject;
  return self;
}

static NXDefaultsVector def=
  {
    { "WindowX", "250"},
    { "WindowY", "400"},
    { "WindowSize", "350"},
    { "DialSize", ".05"},
    { "ClockType", "3"},
    {NULL},
  };

- appDidInit:sender		// get info such as window positioning.
{
  NXRegisterDefaults( [self appName], def);
  [clockView setDialSize:atof( NXGetDefaultValue( [self appName], "DialSize"))];
  [dialSizeSlider setFloatValue:[clockView dialSize]];
  [clockView setClockType:atoi( NXGetDefaultValue( [self appName], "ClockType"))];
  [typeMatrix selectCellWithTag:[clockView clockType]];
  
  [[clockView window]
	      moveTo:atof( NXGetDefaultValue( [self appName], "WindowX"))
		    :atof( NXGetDefaultValue( [self appName], "WindowY"))];
  [[clockView window]
	      sizeWindow:atof( NXGetDefaultValue( [self appName], "WindowSize"))
	                :atof( NXGetDefaultValue( [self appName], "WindowSize"))];
  
  [[clockView window] display];			// Let's redraw some stuff.
  [[clockView window] orderFront:self];		// and then display it.
  [[clockView animator] start:self];		// start the fun!
  return self;
}

@end
