/* File:	Magnify.m - Application class for 'Magnify'
 *
 * By:		Christopher Lane
 *		Symbolic Systems Resources Group
 *		Knowledge Systems Laboratory
 *		Stanford University
 *
 * Date:	6 March 1990
 *
 * Copyright:	1990 by The Leland Stanford Junior University.  This program
 *		may be distributed without restriction for non-commercial use.
 */

#import "Magnify.h"

#import <ctype.h>

#define getDefault(s) NXGetDefaultValue(APPLICATION, s)
#define registerDefaults(s) NXRegisterDefaults(APPLICATION, s)

static NXDefaultsVector MagnifyDefaults = { {SCALEDEFAULTSTRING, DEFAULTSCALESTRING}, {NULL} };

@implementation Magnify : Application

+ new
{
	const char *string;

	self = [super new];
    
	(void) registerDefaults(MagnifyDefaults);
	if ((string = getDefault(SCALEDEFAULTSTRING)) == NULL || sscanf(string, "%f", &scale) != 1)
		scale = DEFAULTSCALE;
	
	return self;
}

- appDidInit:sender
{	
	Window *window = [view window];
	Menu *menu = [self mainMenu];
	MenuCell *cell;
	
	[view setNextResponder:[window firstResponder]];
	[self setWindowTitle];
	[[window makeFirstResponder:view] addToEventMask:NX_MOUSEMOVEDMASK];
	[window makeKeyAndOrderFront:self];
	
	if ((cell = [menu findCellWithTag:FROZENMENUCELLTAG]) != nil) {
		[cell setUpdateAction:@selector(isFrozenUpdateAction:) forMenu:menu];
		[menu update];
		}
		
	return self;
}

- hide:sender
{
	if (![view isFrozen]) [[view window] removeFromEventMask:NX_MOUSEMOVEDMASK];
	
	return [super hide:sender];
}

- unhide:sender
{
	if (![view isFrozen]) [[view window] addToEventMask:NX_MOUSEMOVEDMASK];
	
	return [super unhide:sender];
}

- changeScale:sender
{
	float value;
	const char *string = [[sender selectedCell] title];
        
	if (string == NULL || sscanf(string, "%f", &value) != 1 || value == scale) return self;
	scale = value;
	
	[view createWindows:scale];
	[self setWindowTitle];
        
	return self;
}

- (float) getScale { return scale; }

- (MagnifyView *) getView { return view; }
- setView:(MagnifyView *) anObject { view = anObject; return self; }

- setVersion:anObject
{
	[(version = anObject) setStringValue:VERSION];
	
	return self;
}

- setWindowTitle
{
	char title[] = WINDOWTITLEPROTOTYPE;
	
	sprintf(title, WINDOWTITLEFORMAT, scale);
	[[view window] setTitle:title];
        
	return self;
}

- (BOOL) isFrozenUpdateAction:(MenuCell *) anObject
{
	BOOL flag = [[NXApp getView] isFrozen];
	
	if ([anObject tag] == flag) return NO;
	
	[[anObject setTag:(int) flag] setTitle:(flag) ? UNFROZENMENUTITLE : FROZENMENUTITLE];
	[anObject setKeyEquivalent:tolower([anObject title][0])];
	
	return YES;
}

@end
