
#import <appkit/Application.h>

@interface TextApp : Application
{
    id	text;
    int miniWinNum, winNum;
}

	/*
	  These routines provide for actions to be performed by
	  certain "command-equivalents".  These all are probably
	  appropriate for connection to menu buttons, but in this
	  application they are just dispatched directly from
	  getNextEvent:waitFor:threshold:.  insert: may not be
	  obvious - it allows the user to insert another file at
	  the current corsor position.
	*/
-(BOOL)save:sender;
-(BOOL)saveAs:sender;
- revert:sender;
- new:sender;
- open:sender;
- insert:sender;

	/*
	  These versions of the above routines have an element of
	  "force" about them.  They will _not_ prompt the user if
	  the action will trash the current file.
	*/
- New:sender;
- Open:sender;
- Quit:sender;
- Revert:sender;

	/*
	  These are called by the window because the application
	  is the window delegate.  windowWillClose: makes sure that
	  the window is saved, and if not, allows the user to save
	  it, or cancel the close.  windowDidDeminiaturize: handles
	  un-inverting the window's icon if the window has been
	  edited.  windowWillMiniaturize:toMiniwindow: stores the
	  miniwindow number in miniWinNum, and inverts the window's
	  icon if need be.
	*/
- windowWillClose:sender;
- windowDidDeminiaturize:sender;
- windowWillMiniaturize:sender toMiniwindow:mw;

	/*
	  text:isEmpty: is sent to the application as the Text
	  instance's delegate.  This method ensures that the window
	  is notifying of the document editting, so that the close
	  button can reflect this.  setText: is used to initialize
	  the text outlet.  If the passed object is a ScrollView,
	  the text outlet is set to the docView of that object.
	*/
- text:sender isEmpty:(BOOL)flag;
- setText:anObject;

	/*
	  This routine is overridden to handle command-key equivalents,
	  due to our lack of a main menu.  It also must handle
	  deminiaturizing the miniwindow if needed, because the
	  application runs in a modal loop discarding events for
	  other windows.
	*/
-(NXEvent *)getNextEvent:(int)mask waitFor:(double)timeout threshold:(int)level;

	/*
	  run sets up everything correctly, reading in the text if
	  in Burst mode, etc, etc.  run then runs-modal for the
	  main window.  This is because I didn't want a "real"
	  application, but a disembodied window.  I was also looking
	  for speed of startup.
	*/
- run;

@end
