/* Transformation3D.h */

/*	Transformation3D is an abstract superclass. It should be used for objects
	(such as Linear3D) which implement various 3D transformations that can be
	done to variables of type Vector3D (defined in 3D.h). 
	Matrix can handle linear transformations, but subclasses of either
	Transformation 3D or Matrix should be created for
	faster or non-linear operations. */
	


#import <objc/Object.h>
#import "3D.h"

@interface Transformation3D:Object
{
}

- operateOn:(vector3D *)theVect;

/*	- operateOn should be a DESTRUCTIVE routine wich modifies the structure
	which theVect points to in whatever way the subclass desires */
	
- operateOn:(vector3D *)theVects howMany:(int)count;

/* - operateOn: howMany: should be a way to perform the same operation on
	count Vector3D's. Again it should be destructive, and modify theVects[0]
	through theVects[count - 1] */
	
@end
