
/* Generated by Interface Builder */

#import <objc/Object.h>
#import <objc/Storage.h>

#import <appkit/appkit.h>

#import "ConferenceSpeaker.h"
#import "ConferenceListener.h"

#define STRING_LENGTH 50
#define NETWORKENTRYPERIOD 1.0
#define ALARMENTRYPERIOD 0.1
#define MAXALARMS 5

// We assume port_t is int, or rather, or length int.
#define MEMBERSTORAGEDESCRIPTION "{[STRING_LENGTHc][STRING_LENGTHc]i}"
#define MACHINESTORAGEDESCRIPTION "[STRINGLENGTHc]"

#define APPNAME "SomeRandomStringLikeThis"

typedef struct {
    char user[STRING_LENGTH];
    char username[STRING_LENGTH];
    char machine[STRING_LENGTH];
    port_t port;
} MemberRecord;

@interface Controller:Object
{
    //  Objects on the interaction window.
    id	inputText;
    id	logText;
    
    //  Objects on the participants window.
    id  memberBrowser;

    //  Objects on the Preferences panel.
    id  loginSwitch;
    id  machineSwitch;
    id  realSwitch;
    id  machineBrowser;
    id  useConferenceSwitch;
    id  useNetworkSwitch;
    id  noisyAlertSwitch;
    id  visualAlertSwitch;
    id  activateOnAlertSwitch;
    id  soundFileTextField;
    
    //  Outlets connected in the nib, that aren't controlled from the nib.
    id  coverButton;
    id  addMachinePanel;
    id  addMachineField;
    
    //  Outlets used internally (not connected to the nib).
    id  alertSound;
    id  alertWindow;
    id  memberStore;
    id  speak;
    id  listen;
    
    //  Non-objects.
    char homedir[STRING_LENGTH];
    MemberRecord me;
    DPSTimedEntry netTimedEntry;
    DPSTimedEntry alarmTimedEntry;
    int numberAlarms;
}

// Functions used internally.
void killCr(char *c, int len);
int membercmp(MemberRecord *r1, MemberRecord *r2);
void copymember(MemberRecord *r1, MemberRecord *r2);

// Dummy functions used for timed entry.
DPSTimedEntryProc networkEntryHandler(DPSTimedEntry num,
					    double now, 
					    char *userData);
DPSTimedEntryProc alarmEntryHandler(DPSTimedEntry num,
					    double now, 
					    char *userData);

// Object initializer.
- init;

// Actions called by nib connection.
- addMachineQuit:sender;
- addMachineOk:sender;
- fetchSound:sender;
- quit:sender;
- changePref:sender;
- addMachine:sender;
- removeMachine:sender;
- connectMember:sender;
- disconnectMember:sender;
- connectMachine:sender;
- disconnectMachine:sender;
- selectAllMembers:sender;
- yeahRight:sender;

// Actions called from within Controller.
- doConferenceFile:sender;
- doNetwork:sender;
- setDefaults:sender;
- getDefaults:sender;

// I/O handlers for Text.
- input:sender;
- doOutput:(char *)msg withSender:(MemberRecord *)owner andBold:(BOOL)bold;

// Alarm response/Timed Entry methods.
- handleAlarm;
- doAlarmTimedEntry:sender;
- doNetworkTimedEntry:sender;

// Miscellaneous data-checking and retrieval methods.
- (BOOL)gotMemberWithMachine:(const char *)machine;
- (BOOL)gotMember:(MemberRecord *)mem;
- getBrowserString:(char *)str fromMember:(MemberRecord *)mem;

// ".Conference" file handling methods.
- addMachineToConferenceFile:(const char *)machine;
- removeMachineFromConferenceFile:(const char *)machine;

// application delegated methods
- appDidInit:sender;

// browser delegated methods
-(int)browser:sender fillMatrix:matrix inColumn:(int)column;

// text delegated methods
- textDidEnd:sender endChar:(unsigned short)whyEnd;

// speaker/listener delegated methods
- (int)helloIAm:(char *)fr length:(int)len;
- (int)goodByeIAmLeaving:(char *)fr length:(int)len;
- (int)sendMessage:(char *)msg from:(char *)fr length:(int)len;

@end
